﻿/*

"loc_langs" - the object holding all items that need localizations

In order for translations to work, the string in HTML source
should be encapsulated in a <span> with a class set to "l_"
PLUS the unique name of the sub-object containing its
translations.

For example, to translate "Install all" in HTML source, find
(or add) that sub-item in the langs object.  It already
exists with a name of "installAll".  Therefore the <span>
surrounding the text in the HTML source should be assigned a
class of "l_installAll". Example:

    <span class="l_installAll">Install all</span>

It's easy enough to add new translated strings.  Simply copy
one of the existing below, give it a unique name, and enter
the translated strings.  Then add the "l_" + unique name
class to a <span> around the original string in the HTML
source.
*/

loc_supportedLangs = [
"en", // English
"ptb", // Portuguese (Brazilian)
"de", // German
"fr", // French
"es", // Spanish
"it", // Italian
"ko", // Korean
"jp", // Japanese
"ch", // Chinese (Simplified)
"cht" // Chinese (Traditional)
];

loc_langs = {

// Prices
//---------------------

  newPriceUE: {
    en: '$49.95',
    ptb: '$49.95',
    de: '$49,95',
    fr: '49,95 $',
    es: '$49.95',
    it: '$49.95',
    ko: '$49.95',
    jp: '$49.95',
    ch: '$49.95',
    cht: '$49.95'
  },

  upgradePriceUE: {
    en: '$24.95',
    ptb: '$24.95',
    de: '$24,95',
    fr: '24,95 $',
    es: '$24.95',
    it: '$24.95',
    ko: '$24.95',
    jp: '$24.95',
    ch: '$24.95',
    cht: '$24.95'
  },

  ueucPriceRetailAmt: {
    en: '$129.95',
    ptb: '$129.95',
    de: '$129,95',
    fr: '129,95',
    es: '$129.95',
    it: '$129.95',
    ko: '$129.95',
    jp: '$129.95',
    ch: '$129.95',
    cht: '$129.95'
  },

  ueucPriceAmt: {
    en: '$99.95',
    ptb: '$99.95',
    de: '$99,95',
    fr: '99,95 $',
    es: '$99.95',
    it: '$99.95',
    ko: '$99.95',
    jp: '$99.95',
    ch: '$99.95',
    cht: '$99.95'
  },

  upgradeueucPrice: {
    en: '$69.95',
    ptb: '$69.95',
    de: '$69,95',
    fr: '69,95 $',
    es: '$69.95',
    it: '$69.95',
    ko: '$69.95',
    jp: '$69.95',
    ch: '$69.95',
    cht: '$69.95'
  },

// Trial text
//---------------------

  trialModeText: {
    en: '<span class="appname"></span> is running in trial mode.',
    ptb: 'O <span class="appname"></span> está sendo executado em modo de avaliação.',
    de: '<span class="appname"></span> wird im Testmodus ausgeführt',
    fr: '<span class="appname"></span>\'s exécute en mode d’essai.',
    es: '<span class="appname"></span> está ejecutándose en modo de prueba',
    it: '<span class="appname"></span> è in esecuzione in modalità di valutazione ',
    ko: '<span class="appname"></span> - 평가판 모드에서 구동 중입니다.',
    jp: '<span class="appname"></span> は体験版として動作しています',
    ch: '<span class="appname"></span> 运行的是试用模式。',
    cht: '<span class="appname"></span> 正在試用模式下執行'
  },

  trialDaysText: {
    en: 'Days left in free trial:',
    ptb: 'Dias restantes na avaliação gratuita:',
    de: 'Verbleibende Tage:',
    fr: 'Jours restants :',
    es: 'Días restantes:',
    it: 'Giorni rimanenti:',
    ko: '남은 기간:',
    jp: '残り日数:',
    ch: '剩余日子:',
    cht: '剩餘天數：'
  },

  trialExpiring: {
    en: 'Your free trial is expiring.',
    ptb: 'Sua avaliação gratuita está expirando.',
    de: 'Ihre kostenlose Testversion läuft ab.',
    fr: 'Votre essai gratuit arrive à expiration.',
    es: 'Su versión de prueba está a punto de caducar.',
    it: 'La versione di valutazione sta per scadere. ',
    ko: '무료 평가판이 만료됩니다.',
    jp: '無料の試用期間が間もなく終了します。',
    ch: '您的免费试用期即将到期。',
    cht: '您的免費試用期即將過期。'
  },

  trialAlmostExpiredText: {
    en: 'Your free trial has almost expired.',
    ptb: 'Sua avaliação gratuita está quase expirando.',
    de: 'Die Probezeit ist fast abgelaufen.',
    fr: 'La p&eacute;riode d\'essai expire bient&ocirc;t.',
    es: 'Periodo de prueba finalizando.',
    it: 'La trial e\' quasi scaduta.',
    ko: '시험사용기간이 얼마 남지 않았습니다.',
    jp: 'あと少しで試用期間が切れます',
    ch: '您的试用版本已经过期了。',
    cht: '你的試用差不多要結束了'
  },

  trialExpiredText: {
    en: 'Your free trial has expired.',
    ptb: 'Sua avaliação gratuita expirou.',
    de: 'Die Probezeit ist vorbei.',
    fr: 'Votre p&eacute;riode d\'essai a expir&eacute;.',
    es: 'Fin del periodo de prueba.',
    it: 'La trial e\' scaduta.',
    ko: '시험사용기간이 종료되었습니다.',
    jp: '試用期間が切れました',
    ch: '您的试用版本已经期满了。',
    cht: '你的試用已到期'
  },

  noTrialDaysText: {
    en: 'Please purchase a license to continue using <span class="appname"></span>.',
    ptb: 'Compre uma licença para continuar usando o <span class="appname"></span>.',
    de: 'Bitte kaufen Sie eine Lizenz, um <span class="appname"></span> weiterhin benutzen zu können.',
    fr: 'Veuillez acheter la licence pour continuer à utiliser <span class="appname"></span>.',
    es: 'Compre una licencia para seguir utilizando <span class="appname"></span>.',
    it: 'Acquistare una licenza per continuare a utilizzare <span class="appname"></span>. ',
    ko: '<span class="appname"></span> 애플리케이션을 계속 사용하려면 라이센스를 구입하십시오.',
    jp: '<span class="appname"></span>を継続して使用するには、ライセンスを購入してください。',
    ch: '请购买许可证以继续使用 <span class="appname"></span>。',
    cht: '請購買授權以繼續使用<span class="appname"></span>。'
  },

// UC benefits text
//---------------------

  bftHead: {
    en: 'Your personal license includes:',
    ptb: 'Sua licença pessoal inclui:',
    de: 'Ihre persönliche Lizenz:',
    fr: 'Votre licence personnelle:',
    es: 'Su licencia personal:',
    it: 'La tua licenza personale:',
    ko: '귀하의 개인 라이센스는:',
    jp: 'ご自身のの個人ライセンス:',
    ch: '你的个人许可证::',
    cht: '你的個人許可證:'
  },

  bftMultiPlatform: {
    en: 'The <strong>Windows</strong>, <strong>Mac</strong>, and <strong>Linux</strong> versions',
    ptb: 'As versões <strong>Windows</strong>, <strong>Mac</strong> e <strong>Linux</strong>',
    de: 'Enthält Versionen für <strong>Win</strong>, <strong>Mac</strong> und <strong>Linux</strong>',
    fr: '<span style="font-size: 80%;">Comprend les versions <strong>Windows</strong>, <strong>Mac</strong> et <strong>Linux</strong></span>',
    es: 'Incluye versiones para <strong>Win</strong>, <strong>Mac</strong> y <strong>Linux</strong>',
    it: '<span style="font-size: 80%;">Include versioni <strong>Win</strong>, <strong>Mac</strong> e <strong>Linux</strong></span>',
    ko: '<strong>Win</strong>, <strong>Mac</strong>, <strong>Linux</strong> 버전이 포함됩니다',
    jp: '<span style="font-size: 80%;">それには<strong>Win</strong>、<strong>Mac</strong>、<strong>Linux</strong>バージョンがあります</span>',
    ch: '包括 <strong>Win</strong>、<strong>Mac</strong> 和 <strong>Linux</strong> 版本',
    cht: '包括 <strong>Win</strong>、<strong>Mac</strong> 和 <strong>Linux</strong> 版本'
  },

  bftThreeInstalls: {
    en: 'Installation on up to 3 machines',
    ptb: 'Instalação em até 3 máquinas',
    de: 'Installation auf bis zu 3 Maschinen',
    fr: '<span style="font-size: 80%;">Installation sur trois ordinateurs</span>',
    es: 'Instalación en hasta 3 equipos',
    it: '<span style="font-size: 70%;">Installazione consentita su un massimo di 3 macchine</span>',
    ko: '최대 3대까지 설치',
    jp: '最大で3台の機器にインストール可能',
    ch: '最多可在 3 台计算机上安装',
    cht: '可在最多 3 部機器上安裝'
  },

  bftFreeUpgrades: {
    en: 'Free upgrade to the next release',
    ptb: 'Atualização grátis para a próxima versão',
    de: '<span style="font-size: 90%;">Kostenloses Upgrade auf die nächste Version</span>',
    fr: '<span style="font-size: 75%;">Mise à jour gratuite vers la nouvelle version</span>',
    es: 'Actualización gratuita a la próxima versión',
    it: '<span style="font-size: 70%;">Aggiornamento gratuito all\'uscita della prossima versione</span>',
    ko: '새 버전으로 무료 업그레이드',
    jp: '次回リリースの無償アップグレード',
    ch: '免费升级到下一个版本',
    cht: '免費升級到下一個版本'
  },

  bftTechSupport: {
    en: 'Unlimited lifetime tech support',
    ptb: 'Suporte técnico vitalício ilimitado',
    de: 'Zeitlich unbegrenzter technischer Support',
    fr: '<span style="font-size: 80%;">Soutien tech. illimité pour la durée de vie du produit</span>',
    es: 'Soporte técnico ilimitado de por vida',
    it: '<span style="font-size: 80%;">Assistenza tecnica illimitata a vita</span>',
    ko: '평생 무제한 기술 지원',
    jp: '生涯無制限のテクニカルサポート',
    ch: '无限制的终身技术支持',
    cht: '無限制的終身技術支援'
  },

  worldsBest: {
    en: '<span class="bdlname"></span> and <span class="appname"></span>:<br>the world&#39;s #1 text editor solution.',
    ptb: '<span class="bdlname"></span> and <span class="appname"></span>:<br>A solução de edição &#39;s nº 1 do mundo.',
    de: '<span class="bdlname"></span> und <span class="appname"></span>:<br>Die weltweit beliebteste Text-Bearbeitungslösung',
    fr: '<span class="bdlname"></span> et <span class="appname"></span>:<br>Numéro 1 des solutions d\'édition de texte au monde',
    es: '<span class="bdlname"></span> y <span class="appname"></span>:<br>La solución de edición de texto número 1 del mundo',
    it: '<span class="bdlname"></span> e <span class="appname"></span>:<br>La soluzione di editing testuale n. 1 al mondo',
    ko: '<span class="bdlname"></span> + <span class="appname"></span>:<br>세계 최고의 텍스트 편집 솔루션입니다',
    jp: '<span class="bdlname"></span> + <span class="appname"></span>:<br>世界でNo.1のテキスト編集ソリューションです',
    ch: '<span class="bdlname"></span> + <span class="appname"></span>:<br>全球一流的文本编辑解决方案',
    cht: '<span class="bdlname"></span> + <span class="appname"></span>:<br>全球一流的文本編輯解?方'
  },

// Static license/purchase
// buttons and text
//---------------------

  licenseApp: {
    en: 'License <span class="appname"></span>',  // Translation note: this is the verb form of "license"
    ptb: 'Licença <span class="appname"></span>',
    de: 'Lizenz <span class="appname"></span>',
    fr: '<span style="font-size: 80%;">Délivrer une licence pour <span class="appname"></span></span>',
    es: '<span style="font-size: 85%;">Obtener licencia para <span class="appname"></span></span>',
    it: 'Licenza <span class="appname"></span> ',
    ko: '<span class="appname"></span> 라이센스 구입',
    jp: '<span class="appname"></span> のライセンス ',
    ch: '授权 <span class="appname"></span>',
    cht: '授權<span class="appname"></span>'
  },

  purchaseOptions: {
    en: 'Purchase options',
    ptb: 'Opções de compra',
    de: 'Kaufoptionen',
    fr: 'Options d’achat',
    es: 'Opciones de compra',
    it: 'Opzioni di acquisto',
    ko: '구매 옵션',
    jp: '購入オプション',
    ch: '购买选项',
    cht: '購買選項'
  },

  buyNew: {
    en: 'Buy new:',
    ptb: 'Comprar novo:',
    de: 'Neu kaufen:',
    fr: 'Acheter neuf :',
    es: 'Comprar nueva:',
    it: 'Acquista nuova: ',
    ko: '새로 구매:',
    jp: '新しく購入する：',
    ch: '购买新产品：',
    cht: '購買新的：'
  },

  btnUpgrade: {
    en: 'Upgrade',    // Translation note: this is the verb form of "upgrade"
    ptb: 'Atualizar',
    de: 'Upgrade',
    fr: 'Mettre à niveau',
    es: 'Actualizar',
    it: 'Aggiorna ',
    ko: '업그레이드',
    jp: 'アップグレード',
    ch: '升级',
    cht: '升級'
  },

  btnNew: {
    en: 'New',
    ptb: 'Novo',
    de: 'Neu',
    fr: 'Nouveau',
    es: 'Nuevo',
    it: 'Nuovo ',
    ko: '신규',
    jp: '新しい',
    ch: '新的',
    cht: '新增'
  },

  phoneOrder: {
    en: 'You can also call +1-513-892-8600 to order over the phone.',
    ptb: 'Você também pode ligar para +1-513-892-8600 para comprar pelo telefone.',
    de: 'Unter +1-513-892-8600 sind auch telefonische Bestellungen möglich.',
    fr: 'Vous pouvez également appeler le  +1-513-892-8600 pour commander par téléphone.',
    es: 'También puede llamar al número +1-513-892-8600 para hacer el pedido por teléfono.',
    it: 'È anche possibile effettuare l\'ordine per telefono, chiamando il numero<br>+1-513-892-8600. ',
    ko: '전화로 주문하는 경우 +1-513-892-8600번을 이용해 주십시오.',
    jp: '電話（+1-513-892-8600）から注文することもできます。',
    ch: '您也可以通过电话拨打 +1-513-892-8600 订购。',
    cht: '您也可以致電：+1-513-892-8600 以透過電話訂購。'
  },

  enterLicenseKey: {
    en: 'Enter license key',
    ptb: 'Insira a chave da licença',
    de: 'Lizenzschlüssel eingeben',
    fr: 'Saisir la clé de licence',
    es: 'Introducir clave de licencia',
    it: 'Inserire chiave di licenza ',
    ko: '라이센스 키 입력',
    jp: 'ライセンス番号を入力してください',
    ch: '输入许可证密钥',
    cht: '輸入授權金鑰'
  },

  support: {
    en: 'Resources and support',
    ptb: 'Recursos e suporte',
    de: 'Support',
    fr: 'Assistance',
    es: 'Soporte',
    it: 'Risorse ed assistenza ',
    ko: '리소스 및 지원',
    jp: 'リソースとサポート',
    ch: '资源和支持',
    cht: '資源與支援'
  },

  version: {
    en: 'Version info',
    ptb: 'Informação de versão',
    de: 'Versionsinformationen',
    fr: 'Informations sur la version',
    es: 'Información de versión',
    it: 'Info versione',
    ko: '버전 정보',
    jp: 'バージョン情報',
    ch: '版本信息',
    cht: '版本資訊'
  },

// UE/UC bundle text
//---------------------

  bundleHeadline: {
    en: '<strong>Best value:</strong> <span class="bdlname"></span> / <span class="appname"></span> bundle',
    ptb: '<strong>O melhor valor: </strong><span class="appname"></span> / <span class="bdlname"></span> pacote',
    de: '<strong>Bester Preis:</strong> <span class="bdlname"></span> / <span class="appname"></span>',
    fr: '<strong>Le meilleur :</strong> <span class="bdlname"></span> / <span class="appname"></span>',
    es: '<strong>Mejor valor:</strong> <span class="bdlname"></span> / <span class="appname"></span>',
    it: '<strong>Miglior prezzo:</strong> <span class="bdlname"></span> / <span class="appname"></span>',
    ko: '<strong>최상의 가격:</strong> <span class="bdlname"></span> / <span class="appname"></span>',
    jp: '<strong>お買い得:</strong> <span class="bdlname"></span> / <span class="appname"></span>',
    ch: '<strong>最好价格 :</strong>  <span class="bdlname"></span> / <span class="appname"></span>',
    cht: '<strong>最優惠的價格 :</strong> <span class="bdlname"></span> / <span class="appname"></span>'
  },

  ueucPriceRetailText: {
    en: 'Retail:',
    ptb: 'Varejo:',
    de: '<span style="font-size: 75%;">Normalpreis:</span>',
    fr: '<span style="font-size: 75%;">Vente au d&eacute;tail :</span>',
    es: 'Precio:',
    it: 'Prezzo:',
    ko: '소비자가:',
    jp: '小売価格:',
    ch: '零售价:',
    cht: '零售：'
  },

  ueucPriceText: {
    en: 'You pay:',
    ptb: 'Você paga:',
    de: 'Sie zahlen:',
    fr: '<span style="font-size: 75%;">Vous payez :</span>',
    es: 'Usted Paga:',
    it: 'Paghi:',
    ko: '할인가:',
    jp: '特別価格:',
    ch: '您的价格:',
    cht: '需付款項：'
  },

  ueucBft1: {
    en: 'Integrated with <span class="bdlabbr"></span>',
    ptb: 'Integrado com <span class="bdlabbr"></span>',
    de: 'Integriert mit <span class="bdlabbr"></span>',
    fr: 'Intégré à <span class="bdlabbr"></span>',
    es: 'Integrado con <span class="bdlabbr"></span>',
    it: 'Integrata con <span class="bdlabbr"></span>',
    ko: '<span class="bdlabbr"></span>와 통합',
    jp: '<span class="bdlabbr"></span>の統合',
    ch: '与 <span class="bdlabbr"></span> 整合',
    cht: '與 <span class="bdlabbr"></span> 整合'
  },

  ueucBft2: {
    en: 'Integrate with version control',
    ptb: 'Integre com controle de versão',
    de: 'Mit Versionskontrolle',
    fr: 'Intégrer au contrôle de version',
    es: 'Y con control de versiones',
    it: 'Integrata con controllo versione ',
    ko: '버전 관리와 통합',
    jp: 'バージョン管理機能の統合',
    ch: '与版本控制整合',
    cht: '與版本控制整合'
  },

  ueucBft3: {
    en: 'Diff up to 3 files/folders',
    ptb: 'Compare diferenças de até 3 arquivos/pastas',
    de: 'Diff für bis zu 3 Dateien/Ordner',
    fr: 'Différentiel sur 3 fich./dossiers',
    es: 'Hasta 3 archivos/carpetas',
    it: 'Diff fino a 3 file/cartelle ',
    ko: '최대 3개 파일/폴더 비교',
    jp: ' 3つのファイル/フォルダ', //original: 3つのファイル/フォルダまで差分可能
    ch: '可区分最多 3 个文件/文件夹',
    cht: '可區分最多 3 個檔案/資料夾'
  },

  ueucBft4: {
    en: 'Compare Word docs, PDFs',
    ptb: 'Compare documentos do Word, PDFs',
    de: 'Doc(x) und PDFs vergleichen',
    fr: 'Comparer des doc Word, PDF',
    es: 'Comparar Doc(x), PDF',
    it: 'Documenti Word e PDF ',
    ko: 'Word 문서, PDF 비교',
    jp: 'Word文書やPDFファイルを比較',
    ch: '比较 Word 文件、PDF',
    cht: '比較 Word 文件、PDF'
  },

  ueucBft5: {
    en: 'Sync local to FTP',
    ptb: 'Sincronize local com FTP',
    de: 'Lokal nach FTP synchronisieren',
    fr: 'Syncrho local avec FTP',
    es: 'Sincronización local en FTP',
    it: 'Sincronizza locale su FTP ',
    ko: '로컬을 FTP에 동기화',
    jp: 'FTPとのローカル同期',
    ch: '同步本机至 FTP',
    cht: '同步本機至 FTP'
  },

  ueucBft6: {
    en: 'Compare & preview HTML',
    ptb: 'Compare e visualize HTML',
    de: 'HTML Vergleich und Vorschau',
    fr: 'Comparer/prévisualiser HTML',
    es: 'Comparar y previsualizar HTML',
    it: 'Confronto e anteprima HTML ',
    ko: 'HTML 비교 및 미리보기',
    jp: 'HTMLの比較とプレビュー',
    ch: '比较和预览 HTML',
    cht: '比較與預覽 HTML'
  },

  ueucBft7: {
    en: 'Merge differences',
    ptb: 'Mescle diferenças',
    de: 'Unterschiede zusammenführen',
    fr: 'Fusionner les différences',
    es: 'Combinar diferencias',
    it: 'Unisci differenze',
    ko: '차이 병합',
    jp: '差分を統合',
    ch: '合并差异',
    cht: '合併差異'
  },

  ueucBft8: {
    en: 'Save compare sessions',
    ptb: 'Salve sessões de comparação',
    de: 'Vergleichssitzung speichern',
    fr: 'Sessions de comparaison',
    es: 'Sesiones de comparación',
    it: 'Salva sessioni di confronto',
    ko: '비교 세션 저장',
    jp: 'セッションを比較保存',
    ch: '保存比较会话',
    cht: '儲存比較工作階段'
  },

  ueucSavingsPercent: {
    en: 'Save 60%',
    ptb: 'Economize 60%',
    de: '60 % für <span class="appabbr"></span>',
    fr: '<span style="font-size: 90%;">Économisez 60 %</span>',
    es: 'Ahorre un 60%',
    it: 'Salva 60%',
    ko: '<span class="bdlabbr"></span>과 함께 번들로 구매해서 ',
    jp: '<span class="bdlabbr"></span>との同時購入で、<span class="appabbr"></span>が',
    ch: '您将其与 <span class="bdlabbr"></span> 绑定时，节省 60%',
    cht: '節省 60%'
  },

  ueucSavingsText: {
    en: 'on <span class="appabbr"></span> when you bundle it with <span class="bdlabbr"></span>!',
    de: 'beim Bündeln mit <span class="bdlabbr"></span> sparen!',
    fr: 'sur <span class="appabbr"></span> lorsque vous le groupez à <span class="bdlname"></span> !',
    es: 'en <span class="appabbr"></span> cuando lo compre junto con <span class="bdlname"></span>.',
    it: 'su <span class="appabbr"></span> quando raggruppate con <span class="bdlname"></span>!',
    ko: '<span class="appabbr"></span> 가격을 50% 절약하세요!',
    jp: '50パーセント引き！',
    ch: '的 <span class="appabbr"></span>！',
    cht: '的 <span class="appabbr"></span>，當您與 <span class="bdlabbr"></span> 綑綁時！'
  },

  buyueucNew: {
    en: 'Buy <span class="bdlabbr"></span>/<span class="appabbr"></span> new:',
    ptb: 'Comprar o <span class="appabbr"></span>/<span class="bdlabbr"></span> novos:',
    de: '<span class="bdlabbr"></span>/<span class="appabbr"></span> neu kaufen:',
    fr: 'Acheter <span class="bdlabbr"></span>/<span class="appabbr"></span> neuf :',
    es: 'Comprar nuevo <span class="bdlabbr"></span>/<span class="appabbr"></span>:',
    it: 'Acquista <span class="bdlabbr"></span>/<span class="appabbr"></span> nuovi:',
    ko: '새 <span class="bdlabbr"></span>/<span class="appabbr"></span> 구매:',
    jp: '<span class="bdlabbr"></span>/<span class="appabbr"></span>を新しく購入：',
    ch: '购买新的 <span class="bdlabbr"></span>/<span class="appabbr"></span>：',
    cht: '購買 <span class="bdlabbr"></span>/<span class="appabbr"></span> 新：'
  },

  upgradeueuc: {
    en: 'Upgrade <span class="bdlabbr"></span>, add <span class="appabbr"></span>:',
    ptb: 'Atualizar o <span class="appabbr"></span>, adicionar o <span class="bdlabbr"></span>:',
    de: '<span class="bdlabbr"></span> aktualisieren + <span class="appabbr"></span>:',
    fr: '<span style="font-size: 75%;">Mettre à niveau <span class="bdlabbr"></span>, ajouter <span class="appabbr"></span> :</span>',
    es: 'Actualizar <span class="bdlabbr"></span> + <span class="appabbr"></span>:',
    it: '<span style="font-size: 80%;">Aggiorna <span class="bdlabbr"></span>, aggiungi <span class="appabbr"></span>:</span>',
    ko: '<span class="bdlabbr"></span> 업그레이드, <span class="appabbr"></span> 추가:',
    jp: '<span style="font-size: 70%;"><span class="bdlabbr"></span>をアップグレードし、<span class="appabbr"></span>を追加：</span>',
    ch: '升级 <span class="bdlabbr"></span>，新增 <span class="appabbr"></span>：',
    cht: '升級 <span class="bdlabbr"></span>、新增 <span class="appabbr"></span>：'
  },

// feature showcase text
//---------------------
  learnMore: {
    en: 'Click to learn more',
    ptb: 'Clique para saber mais',
    de: 'F&uuml;r weitere Info hier klicken',
    fr: 'Cliquez ici pour en savoir plus',
    es: 'Pulse aquí para saber más',
    it: 'Clicca qui per saperne di più',
    ko: '더 상세한 정보를 알고 싶으면 여기를 누르세요',
    jp: '詳細はここをクリック',
    ch: '单击这里了解更多',
    cht: '點選這裏進一步學習'
  },

  f_CompareFoldersHead: {
    en: 'Compare your folders, .zip archives, and more with Folder Mode',
    ptb: 'Compare as suas pastas, arquivos .zip e muito mais com o modo pasta',
    de: 'Vergleichen Sie Ordner, .ZIP-Archive und mehr mit Verzeichnisvergleich',
    fr: 'Comparez vos dossiers, archives .zip, etc., avec le mode Dossiers',
    es: 'Compare sus carpetas, archivadores .zip, y m&aacute;s con el Modo Carpetas',
    it: 'Confronta le tue cartelle, gli archivi .zip ed altro con la Modalità Cartelle',
    ko: '폴더 모드에서 사용자의 폴더, Zip 압축파일 등을 비교합니다.',
    jp: 'フォルダ比較、.zip圧縮ファイルの比較、その他多数の機能をフォルダモードで。',
    ch: '比较你的目录、 .zip 档案和更多有关目录方式',
    cht: '以資料夾模式比對你的資料夾、.zip 套件、及更多'
  },

  f_CompareFolders: {
    en: 'Use Folder mode to quickly compare local, network, or remote directories (using the built-in FTP/SFTP support).<br><br>Deep directory structures?  No problem... Folder mode is performance optimized for large directory structures allowing you to start working with the top-level folders while <span class="appname"></span> continues to process the subdirectories in the background.',
    ptb: 'Use o modo pasta para comparar rapidamente diretórios locais, na rede ou remotos (usando o suporte FTP/SFTP integrado). <br><br>Estruturas de diretório muito profundas?  Tudo bem... O modo pasta tem desempenho otimizado para estruturas de diretório muito grandes, permitindo que você comece a trabalhar com pastas de alto nível enquanto <span class="appname"></span> continua processando os subdiretórios em segundo plano.',
    de: 'Setzen Sie Verzeichnisvergleich ein, um lokale Ordner bzw. Netzwerk- oder entfernte Verzeichnisse mittels eingebauter FTP/SFTP-Unterst&uuml;tzung schnell miteinander zu vergleichen.<br><br>Gro&szlig;e Ordnerverschachtelungstiefe? Kein Problem ... Verzeichnisvergleich wurde f&uuml;r tiefe Verschachtelungen in der Leistung optimiert, damit Sie mit der h&ouml;chsten Verzeichnisebene zu arbeiten anfangen k&ouml;nnen, w&auml;hrend <span class="appname"></span> den Vergleich der Unterverzeichnisse im Hintergrund fortsetzt.',
    fr: 'Utilisez le mode Dossiers pour comparer rapidement dossiers locaux, r&eacute;seau ou distants (via le support FTP/SFTP int&eacute;gr&eacute;).<br><br>Des structures de dossiers longues ?  Aucun probl&egrave;me... Le mode Dossiers est optimis&eacute; pour les arborescences complexes : vous pouvez commencer le contr&ocirc;le des dossiers racine pendant qu\'<span class="appname"></span> continue la comparaison en arri&egrave;re-plan des sous-dossiers.',
    es: 'Use el Modo Carpetas para comparar directorios locales, en red o remotos (usando el soporte interno FTP/SFTP).<br><br>&iquest;Estructuras profundas de directorios?  Sin problema... El modo Carpetas est&aacute; optimizado para estructuras grandes de directorios, permitiéndole que empiece a trabajar en el nivel superior mientras UltraCompara contin&uacute;a en segundo plano el proceso de los subdirectorios.',
    it: 'Usa la Modalità Cartelle per confrontare rapidamente cartelle locali, di rete o remote (con il supporto integrato FTP/SFTP).<br><br>Strutture nidificate delle cartelle?  Nessun problema... La Modalità Cartelle è ottimizzata per elaborare in background la struttura delle cartelle partendo dal livello più alto in modo da farti lavorare da subito senza rallentamenti.',
    ko: '로컬, 네트워크 또는 원격 디렉토리(FTP/SFTP 내장 기능을 사용하는 경우)를 빠르게 검색하기 위해 폴더 모드를 사용하세요.<br><br>디렉토리 구조가 복잡하다구요?  문제없습니다. 폴더 모드는 큰 디렉토리 구조에 최적화되어 실행되므로, 백그라운드에서 서브 디렉토리가 처리되는 동안 사용자는 Top-level 폴더에서 작업을 진행할 수 있습니',
    jp: 'フォルダモードを使用してローカル、ネットワークまたはリモートディレクトリ（ビルトインFTP/SFTPサポートを利用）をすばやく比較することができます。<br><br>ディレクトリ階層が深い？問題ありません... フォルダモードは大きなディレクトリ階層でもパフォーマンスを最適化してトップレベルのフォルダからスタートして表示します。その間、<span class="appname"></span>は内部的にサブディレクトリのプロセスを継続しています。',
    ch: '利用目录方式很快地比较本地、网络或远端目录 (利用内置的 FTP/SFTP 支持)。<br><br>深的目录结构?  不是问题... 目录方式是给大目录结构的最好化性能，让你开始运作高级的目录，同时 <span class="appname"></span> 继续在背景进行子目录。',
    cht: '使用資料夾模式以快速比對本機、網路、或遠端目錄 (使用內建的 FTP/SFTP)。<br><br>目錄結構太多層？沒問題... 資料夾模式對大型目錄結構進行效能最佳化，可以讓你從最上層資料夾開始運作。而 <span class="appname"></span> 會繼續在背景處理子目錄。'
  },

  f_SyncFoldersHead: {
    en: 'Sync folders in a single click',
    ptb: 'Sincronize pastas com um só clique',
    de: 'Ordner mit einem Klick synchronisieren',
    fr: 'Synchroniser des dossiers d\'un simple clic',
    es: 'Sincronizar carpetas con un único clic',
    it: 'Sincronizzazione cartelle in un solo clic',
    ko: '클릭 한 번으로 폴더 동기화',
    jp: 'シングルクリックでフォルダを同期',
    ch: '单击一下即可同步文件夹',
    cht:    '單次按鍵操作即可同步資料夾'
  },

  f_SyncFolders: {
    en: 'Synchronize two local, network, or FTP folders quickly and easily with <span class="appname"></span>!<br><br>To run folder sync, while in folder mode, click the "Folder sync" option in the ribbon\'s <strong>Edit</strong> tab. If you have any files you don\'t want changed by the sync, you can manually override sync actions for the files in the folder compare panes.',
    ptb: 'Sincronize duas pastas locais, de rede ou FTP de forma rápida e fácil com <span class="appname"></span>!<br><br>Para executar a sincronização de pasta, durante o modo de pasta, clique na opção “Sincronização de pasta” na guia  <strong>Editar</strong> da faixa de opções. Se você tiver arquivos que não deseja alterar com a sincronização, poderá substituir manualmente as ações de sincronização para os arquivos nos painéis de comparação de pastas.',
    de: 'Synchronisieren Sie mit <span class="appname"></span> schnell und einfach zwei lokale, Netzwerk- oder FTP-Ordner!<br><br>Klicken Sie für die Synchronisation der Ordner, während Sie sich im Ordnermodus befinden, auf dem Reiter im Ribbon <strong>Bearbeiten</strong> auf die Option „Verzeichnissynchronisation“. Wenn Sie Dateien haben, die durch die Synchronisation nicht verändert werden sollen, können Sie diese Dateien in den Bereichen "Ordnervergleich" manuell von den Synchronisationsvorgängen ausschließen.',
    fr: 'Synchroniser facilement deux dossiers en utilisant <span class="appname"></span>, que les dossiers soient locaux, en réseau ou issus d’un serveur FTP !<br><br>Pour lancer la synchronisation de dossiers, cliquez sur l’option « Synchroniser des dossiers » au niveau de l’onglet <strong>Modifier</strong> dans le ruban. Si vous souhaitez que la synchronisation ne modifie pas certains de vos fichiers, vous pouvez outrepasser manuellement les actions de synchronisation pour les fichiers présents dans le volet de comparaison de dossiers.',
    es: 'Sincronice dos carpetas locales, de red o FTP de forma rápida y sencilla con <span class="appname"></span>.<br><br>En el modo de carpeta, para ejecutar la sincronización de carpetas, haga clic en la opción "Sincronización de carpetas" en ficha <strong>Editar</strong> de la cinta de opciones. Si no desea que la sincronización cambie algunos archivos, puede omitir manualmente las acciones de sincronización en dichos archivos en los paneles de comparación de carpetas.',
    it: 'Sincronizza velocemente e facilmente due cartelle locali, di rete o FTP con <span class="appname"></span>!<br><br>Per avviare la sincronizzazione della cartella, in modalità cartelle, clicca l’opzione “sincronizzazione cartella” nella scheda ribbon “<strong>Modifica</strong>”. Se sono presenti file che non si desidera vengano modificati dalla sincronizzazione, è possibile ignorare manualmente le azioni di sincronizzazione per i file nei riquadri di confronto cartelle.',
    ko: '<span class="appname"></span>로 두 개의 로컬, 네트워크 또는 FTP 폴더를 빠르고 쉽게 동기화하십시!<br><br>폴더 모드에서 폴더 동기화를 실행하려면 리본 메뉴의 <strong>편집</strong> 탭에서 "폴더 동기화"옵션을 클릭하십시오. 동기화로 변경하지 않으려는 파일이 있는 경우 폴더 비교 창에서 파일에 대한 동기화 작업을 수동으로 재정의 할 수 있습니다.',
    jp: '二つのローカル、ネットワークやFTPフォルダを<span class="appname"></span>ですぐにそして簡単に同期させることができます！<br><br>フォルダーモードの間にフォルダ同期を実行するには、リボンの<strong>「編集」</strong>タブから 「フォルダー同期」オプションをクリックしてください。同期により変更したくないファイルがある場合は、フォルダ比較ペイン内のファイルに対して手動で同期の操作を無効にすることができます。',
    ch: '利用<span class="appname"></span>轻松快捷同步本地、网络和 FTP 文件夹！<br><br>要同步文件夹，在文件夹模式下， 在功能区中的<strong>编辑</strong>选项卡，点击“文件夹同步”选项。如果有任何您不想通过同步更改的文件，您可以在“文件夹比较”窗格中手动覆盖这些文件的同步操作。',
    cht:'使用<span class="appname"></span>快速、輕鬆地同步兩個本機、網路或 FTP 資料夾。<br><br>若要在資料夾模式下執行資料夾同步，請在功能區的<strong>編輯</strong>選項卡中按一下「資料夾同步」選項。如果您有任何不想要使用同步功能變更的檔案，您可以從資料夾比較窗格中，以手動方式覆寫這些檔案的同步操作。'
  },

  f_CompareTextHead: {
    en: 'Compare text, source code, Word Docs',
    ptb: 'Compare texto, código fonte, documentos do Word',
    de: 'Vergleichen Sie Textdateien, Quelltexte, Word-Dokumente',
    fr: 'Comparer des fichiers texte, un code source, des docs Word',
    es: 'Compare archivos de texto, c&oacute;digo fuente, Documentos Word',
    it: 'Confronta file di testo, codice sorgente, Doc di Word',
    ko: '텍스트 파일, 소스 코드, 워드 문서 등을 비교합니다.',
    jp: 'テキストファイル, ソースコード, ワード書類 など多数のテキストを比較...',
    ch: '比较文本文件、源代码、 Word 文件\'s 和更多...',
    cht: '比對文字檔、原始碼 Word 文件...'
  },

  f_CompareText: {
    en: '<span class="appname"></span> supports 2 and 3 way comparison - great for version control, validating backups, and tracking your team\'s modifications. The relational lines visually link differences between files so you can easily identify and merge differences between your files.<br><br><span class="appname"></span> also higlights the individual character differences within the text making visual inspection of your file differences even faster.',
    ptb: 'O <span class="appname"></span> oferece suporte a comparação em duas e três vias – o que é ótimo para controle de versões, validação de backups e acompanhamento de alterações pela sua equipe. As linhas relacionais vinculam visualmente as diferenças entre os arquivos, de modo que você pode identificar e mesclar diferenças entre arquivos com facilidade. O <br><br><span class="appname"></span> também realça diferenças entre caracteres individuais no texto, tornando a inspeção visual das diferenças entre seus arquivos ainda mais rápidas.',
    de: '<span class="appname"></span> bietet 2- und 3-fach-Vergleiche &ndash; unentbehrlich f&uuml;r Versionskontrolle, Backup-Validierungen und &Auml;nderungen durch Mitarbeiter im Team aufzusp&uuml;ren.<br><br>Die relationalen Linien zeigen die Unterschiede zwischen Ihren Dateien visuell an, damit Sie diese mit Leichtigkeit aufsp&uuml;ren und zusammenf&uuml;hren k&ouml;nnen.',
    fr: '<span class="appname"></span> int&egrave;gre la comparaison &agrave; 2 et 3 panneaux - id&eacute;al pour le contr&ocirc;le des versions, la validation de sauvegardes et le suivi des modifications de votre &eacute;quipe.<br><br>Des lignes lient de mani&egrave;re visuelle les diff&eacute;rences entre les fichiers pour faciliter l\'identification et la fusion des diff&eacute;rences entre vos fichiers.',
    es: '<span class="appname"></span> soporta comparaciones de 2 y 3 v&iacute;as - perfecto para control de versiones, validaci&oacute;n de copias, y seguimiento de las modificaciones de su equipo.<br><br>L&iacute;neas enlazan visualmente las diferencias entre los archivos para facilitar la identificaci&oacute;n y combinaci&oacute;n de las diferencias entre sus archivos.',
    it: '<span class="appname"></span> supporta il confronto a 2 e 3 vie - ottimo per: controllo versione, validazione backup, tracciatura modifiche fatte del tuo team.<br><br>Le linee di relazione mostrano le differenze tra i file in modo da identificare ed unire le differenze tra i file.',
    ko: '<span class="appname"></span>는 2개 또는 3개 문서 비교를 지원합니다 - 버전 관리, 백업 유효성, 팀별 프로젝트의 소스 변경 관리.<br><br>파일들간의 차이나는 부분을 찾아 관계있는 라인들을 시각적으로 연결시킴으로서, 사용자가 쉽게 차이점을 확인하고 병합할 수 있습니다.',
    jp: '<span class="appname"></span> は2, 3 way 比較をサポートしています - バージョンコントロールに最適, バックアップの評価, あなたのチームが編集した部分をトラッキング<br><br>リレーショナルラインでファイル間の相違点を視覚的にリンクします。これによってファイル間の相違点を簡単に判別したり、マージしたりすることができます。',
    ch: '<span class="appname"></span> 支持2方和3方比较 - 对于版本控制、验证备份和追踪你的队伍的更动。<br><br>有联系的行形象化地把文件的分别连起来，所以你可以容易地识别和合并文件的分别。',
    cht: '<span class="appname"></span> 支援雙向及三方比對 - 對於版本控制、檢驗備份、及追蹤小組的修訂相當有用。<br><br>視覺化連結檔案間相關列的差異，這樣你可以輕易的辨識及合併檔案的不同處。'
  },

  f_MergeHead: {
    en: 'Merge differences with block and line mode merge',
    ptb: 'Mescle diferenças com mesclando nos modos bloco e linha',
    de: 'Unterschiede in Block- oder Zeilenmodus &uuml;bernehmen',
    fr: 'Fusionnez avec les modes bloc et ligne',
    es: 'Combine diferencias con modos de combinaci&oacute;n de bloque y l&iacute;nea',
    it: 'Unione differenze in modalità blocco e riga',
    ko: '블럭과 라인 모드 병합에서 차이를 병합합니다',
    jp: '相違点をブロック毎にマージ、行モードでマージ',
    ch: '利用块和行方式合并合并分别',
    cht: '以區表及列模式合併差異'
  },

  f_Merge: {
    en: '<span class="appname"></span> features powerful merge options that give you total control over the differences between your compared files.<br><br><span class="appname"></span> will save you hours with its powerful and intuitive merge features.  You can merge differences using the merge toolbar, the merge icons between compare panes, or by using the Merge menu options.',
    ptb: 'O <span class="appname"></span> oferece opções de mesclagem avançadas que lhe dão controle total sobre as diferenças entre os seus arquivos comparados. O <br><br><span class="appname"></span> economizará horas do seu tempo com recursos de mesclagem avançados e intuitivos.  Você pode mesclar diferenças usando a barra de ferramentas de mesclagem, os ícones de mesclagem entre painéis de comparação ou as opções do menu de mesclagem.',
    de: '<span class="appname"></span> bietet leistungsstarke &Uuml;bernahme-Funktionen, die Ihnen die totale Kontrolle &uuml;ber die Unterschiede zwischen den verglichenen Dateien garantieren.<br><br>Mit <span class="appname"></span> k&ouml;nnen Sie durch Einsatz der intuitiven und m&auml;chtigen &Uuml;bernahme-Funktionen stundenweise Zeit einsparen. Unterschiede k&ouml;nnen durch die &Uuml;bernahme-Symbolleiste, die &Uuml;bernahme-Symbole zwischen Ansichtsfenstern oder die entsprechenden Men&uuml;befehle im Men&uuml; &raquo;&Uuml;bernahmen&laquo; zusammengef&uuml;hrt werden.',
    fr: '<span class="appname"></span> int&egrave;gre la comparaison &agrave; 2 et 3 panneaux - id&eacute;al pour le contr&ocirc;le des versions, la validation de sauvegardes et le suivi des modifications de votre &eacute;quipe.<br><br>Des lignes lient de mani&egrave;re visuelle les diff&eacute;rences entre les fichiers pour faciliter l\'identification et la fusion des diff&eacute;rences entre vos fichiers.',
    es: 'Las potentes opciones de combinaci&oacute;n de <span class="appname"></span> le dan el total control sobre las diferencias entre sus archivos comparados.<br><br><span class="appname"></span> le ahorrar&aacute; horas con sus potentes e intuitivas funciones de combinaci&oacute;n.  Podr&aacute; combinar diferencias usando la barra de combinaciones, los iconos de combinaci&oacute;n entre los paneles de comparaci&oacute;n o las opciones del men&uacute; Combinar.',
    it: '<span class="appname"></span> offre potenti opzioni di unione che ti danno un controllo totale sulle differenze tra i file confrontati.<span class="appname"></span> ti farà risparmiare tempo prezioso con intuitive funzioni di unione.  Puoi unire le differenze tra i file tramite la barra strumenti, le icone di unione tra i pannelli di confronto o usando le voci del menù Unisci.<br><br>',
    ko: '<span class="appname"></span>는 비교된 파일들간의 차이점을 전체적으로 관리할 수 있도록 강력한 병합 옵션을 지원합니다.<br><br><span class="appname"></span> 강력하고 직관적인 병합 기능으로 사용자의 작업 시간을 줄여줍니다. 사용자는 병합 툴바나 비교창 사이의 병합 아이콘, 또는 병합 메뉴 옵션을 사용하여 차이점을 병합할 수 있습니다.',
    jp: '<span class="appname"></span>にはパワフルなマージ機能が備わっています。比較されるファイル中の相違点をトータルにコントロールすることができます。<br><br><span class="appname"></span>  はそのパワフルで直感的なマージ機能であなたの手間を大幅に省きます。マージツールバーや比較ペイン間のマージアイコン、もしくはメニューのマージオプションなどを使用して、相違点をマージすることができます。',
    ch: '<span class="appname"></span> 的强大的合并选择项给你在比较文件分别上完全控制。 <span class="appname"></span> 专业版强大和直觉的功能节省你很多时间。你可以利用合并工具栏、在比较窗格中的比较像标或比较菜单选择项合并分别。',
    cht: '<span class="appname"></span> 提供超強的合併選項，讓你可以完全控制所比對的檔案的差異。<br><br><span class="appname"></span>  的超強及直覺式的合併功能可節省你的時間。你可以使用工具列、比對窗格間的合併圖示、或使用合併功能表選項來合併差異。'
  },

  f_ShellIntegrationHead: {
    en: 'Quickly execute your file and folder compare operations from the right-click menu in Windows Explorer',
    ptb: 'Execute comparações de seus arquivos e pastas com rapidez com o menu de atalho (com o botão direito do mouse) do Windows Explorer.',
    de: 'Vergleichen Sie Dateien und Ordner auf die Schnelle durch Klicken mit der rechten Maustaste im Windows-Explorer',
    fr: 'Des op&eacute;rations de comparaison rapides gr&acirc;ce au menu du clic droit dans l\'Explorateur de Windows.',
    es: 'Ejecute r&aacute;pidamente sus comparaciones de archivos y carpetas mediante el bot&oacute;n derecho del rat&oacute;n en el Explorador de Windows',
    it: 'Esegui rapidamente operazioni di confronto sui tuoi file e cartelle facendo un click destro in Windows Explorer',
    ko: '윈도우 탐색기에서 마우스 오른쪽 버튼 클릭 메뉴로 파일이나 폴더의 비교 작업을 빠르게 실행합니다',
    jp: '素早くファイル/フォルダ比較を実行(Windowsエクスプローラ中の右クリックメニューから実行)',
    ch: '在视窗浏览器的右击菜单迅速的执行文件和目录比较行动',
    cht: '快速的從 Windows 檔案總管的右鍵功能表執行你的檔案及資料夾比對作業'
  },

  f_ShellIntegration: {
    en: 'If you\'re constantly comparing files and directories, you need something that is fast, efficient, and easy to use. <span class="appname"></span> streamlines your compare operations by direcly integrating with Windows Explorer through shell integration.<br><br>Shell integration allows you to mark files in Windows Explorer then run your compare &ndash; all from the convenient right-click menu.',
    ptb: 'Se você compara arquivos e diretórios frequentemente, você precisa de algo rápido, eficiente e fácil de usar. O <span class="appname"></span> simplifica as suas operações de comparação por meio de integração direta com o Windows Explorer via shell.<br><br>A integração do shell permite marcar os seus arquivos no Windows Explorer e, depois, compará-los &ndash; tudo no conveniente menu de atalho.',
    de: 'Wenn Sie Dateien und Ordner st&auml;ndig vergleichen m&uuml;ssen, brauchen Sie etwas schnelles, leistungsf&auml;higes und einfaches f&uuml;r Ihre Arbeit. <span class="appname"></span> gibt Ihnen einen direkten Zugriff auf die Vergleichsfunktionalit&auml;t, indem es in Windows-Explorer integriert wird.<br><br>Windows-Explorer-Einbindung erm&ouml;glicht es, alle zu vergleichenden Dateien in Explorer zu markieren und anschlie&szlig;end einen Vergleich zu starten durch Auswahl des Kontextmen&uml;-Befehls, das durch Klicken mit der rechten Maustaste auf die Dateisymbole eingeblendet wird.',
    fr: 'Si vous comparez constamment des fichiers/dossiers, il vous faut quelque chose de rapide, efficace et facile &agrave; utiliser. <span class="appname"></span> rationalise vos op&eacute;rations de comparaison en s\'int&eacute;grant directement &agrave; l\'Explorateur.<br><br>Ainsi, gr&acirc;ce au menu contextuel de l\'Explorateur de Windows, vous pouvez s&eacute;lectionnez des fichiers dans ce dernier et ex&eacute;cuter imm&eacute;diatement votre comparaison.',
    es: 'Si usted compara continuamente archivos y directorios, necesitar&aacute; este modo r&aacute;pido, eficiente y seguro. <span class="appname"></span> acelera las operaciones de comparaci&oacute;n integr&aacute;ndose directamente con el Explorador de Windows a través de la Integraci&oacute;n con el Explorador.<br><br>La Integraci&oacute;n con el Explorador le permite marcar archivos en el Explorador de Windows para ejecutar su comparaci&oacute;n - todo a través del men&uacute; del bot&oacute;n derecho del rat&oacute;n.',
    it: 'Se devi confrontare spesso file e cartelle hai bisogno di qualcosa di veloce e semplice da usare.  <span class="appname"></span> si integra direttamente in Windows Explorer tramite l\'Integrazione Shell.<br><br>L\'Integrazione Shell ti permette di marcare i file in Windows Explorer per poi eseguire su questi il confronto - tutto grazie ad un click del mouse.',
    ko: '파일이나 폴더를 자주 비교해야 한다면, 사용자는 빠르고, 능률적이며, 쉽게 사용할 수 있는 무언가가 필요할 것입니다.  <span class="appname"></span>는 윈도우 탐색기와의 쉘 통합을 통해 비교 작업을 능률적으로 할 수 있습니다.<br><br>쉘 통합은 윈도우 탐색기에서 파일을 표시하고, 편리하게 마우스 오른쪽 버튼 클릭 메뉴에서 비교를 실행할 수 있습니다.',
    jp: 'もしファイルやディレクトリを頻繁に比較するのであれば、高速で、効率が良く、使いやすいものが良いでしょう。<span class="appname"></span>は、シェルを統合してWindowsエクスプローラを拡張することによって比較作業を合理化しました。<br><br>シェル統合はWindowsエクスプローラ上のファイルをマークし、比較を実行することを可能にしました - 全ては右クリックメニューから',
    ch: '如果你是经常比较文件和目录，你需要一个快、有效率和容易使用。<span class="appname"></span> 利用 Shell 整合视窗浏览器来令比较行动更顺。<br><br>Shell 整合让你在视窗浏览器标记文件和执行比较 - 全部从方便的右击菜单。',
    cht: '如果你經常比對檔案及目錄，你需要類似的方法來更快、更有效率及更簡單的使用。<span class="appname"></span> 可透過與 Windows 檔案總管的殼層整合來流線化你的比對作業。<br><br>殼層整合可以讓你在 Windows 檔案總管中標記檔案然後進行比對 - 一切只需透過方便的右鍵功能表。'
  },

  f_TextSnippetsHead: {
    en: 'Compare text snippets without having to open/save files',
    ptb: 'Comparar trechos de texto sem precisar abrir/salvar arquivos',
    de: 'Vergleichen Sie Textausschnitte, ohne Dateien &ouml;ffnen bzw. sichern zu m&uuml;ssen!',
    fr: 'Comparer des morceaux de textes sans ouvrir/enregistrer de fichiers',
    es: 'Compare fragmentos de texto sin necesidad de salvarlos como archivos',
    it: 'Confronta frammenti di testo senza dover aprire/salvare file',
    ko: '파일을 열기/저장하지 않고 텍스트 조각을 비교합니다',
    jp: '頻繁に使用するファイルやフォルダをお気に入りとして保存しましょう',
    ch: '不需要开/保存文件，而比较文本摘录',
    cht: '比對文字片段而不需要開啟/儲存檔案'
  },

  f_TextSnippets: {
    en: 'Simply copy/paste your text directly into the compare frame!<br><br>You can copy and paste text from a variety of sources including emails, Word Documents, webpages, and more. You\'ll love the text snippet compare, it will greatly enhance the efficiency of your text compare operations.',
    ptb: 'Simplesmente copie e cole seu texto diretamente no quadro de comparação!<br><br>Você pode copiar e colar texto a partir de várias fontes de texto, incluindo e-mails, documentos do Word, páginas da web e muitas outras. Você adorará a comparação de trechos de texto, que aumentará muito a eficiência das suas operações de comparação de texto.',
    de: 'Man kann einen Textausschnitt kopieren und direkt in das Vergleichsfenster einf&uuml;gen!<br><br>Der Text kann aus einer Vielzahl von Anwendungen wie Word-Dokumente, Webseiten, E-Mail-Nachrichten uva. heraus &uuml;bernommen werden. Sie werden die gro&szlig;e Flexibilit&auml;t der Funktion &raquo;Textausschnitte vergleichen&laquo; schnell sch&auml;tzen lernen!',
    fr: 'Il vous suffit de copier/coller votre texte directement dans la fen&ecirc;tre de comparaison !<br><br>Vous pouvez copier et coller du texte &agrave; partir de diff&eacute;rentes sources, y compris les emails, les documents Word, les pages Web, etc.  Vous appr&eacute;cierez cette possibilit&eacute;, qui vous permettra d\'am&eacute;liorer consid&eacute;rablement votre efficacit&eacute;.',
    es: '&iexcl;Simplemente copie/salve su texto directamente en los paneles de comparaci&oacute;n!<br><br>Usted puede copiar y pegar el texto desde una gran cantidad de origenes, incluyendo correos, Documentos Word, p&aacute;ginas web y m&aacute;s.  Usted apreciar&aacute; la comparaci&oacute;n de fragmentos, porque mejorar&aacute; la eficiencia de sus comparaciones de texto.',
    it: 'Copia/incolla semplicemente il testo nei pannelli di confronto!<br><br>Puoi copiare il testo da sorgenti differenti come email, Documenti Word, pagine web ed altro.  Ti piacerà usare il confronto di frammenti di testo, aumenterai la tua efficienza nelle operazioni di confronto del testo.',
    ko: '비교 프레임에서 직접 간단하게 텍스트를 복사/붙여넣기가 가능합니다!<br><br>이메일, 워드 문서, 웹페이지 등을 포함한 다양한 소스에서 텍스트를 복사하고 붙여넣기 할 수 있습니다.  텍스트 조각 비교 기능을 좋아하게 되실 것입니다. 그것은 텍스트 비교 작업의 능률을 훨씬 향상시켜줄 것이기 때문입니다.',
    jp: '同じ組み合わせのファイル/フォルダを頻繁に比較しますか？そうであればお気に入りを使いましょう！<br><br>お気に入りは頻繁に使用するファイル/フォルダをブックマークする便利な方法です。これによって、比較作業中でも素早くファイルやフォルダを出し入れできます。これもまた<span class="appname"></span>が提供する高速で簡単なワークフローの一つです。',
    ch: '只是拷贝/粘贴你的文本到比较框!<br><br>你可以从很多途径拷贝/粘贴文本，例如电邮、Word Documents、网页等。你会喜爱文本摘录比，他会提高你的工作效率。',
    cht: '只需簡單的直接複製/貼上你的文字到比對框架中！<br><br>你可以複製並貼上多種來源，包括電子郵件、Word 文件、網頁、及更多。你會喜歡這個文字片段比對，它可以大大的增進你的文字比對作業。'
  },

  f_FTPHead: {
    en: 'Compare and sync remote files and folders with integrated FTP/SFTP support',
    ptb: 'Compare e sincronize arquivos e pastas remotos com o suporte a FTP/SFTP.',
    de: 'Vergleichen und synchronisieren Sie entfernte Dateien und Ordnern durch die eingebaute FTP/SFTP-Unterst&uuml;tzung',
    fr: 'Comparez et synchronisez des fichiers/dossiers distants avec le support FTP/SFTP int&eacute;gr&eacute;',
    es: 'Comparar y sincronizar archivos y carpetas remotos con el soporte integrado FTP/SFTP',
    it: 'Confronta e sincronizza file e cartelle remoti con il supporto integrato FTP/SFTP',
    ko: '통합된 FTP/SFTP 지원 기능으로 원격 파일이나 폴더를 비교하고 동기화합니다.',
    jp: '統合されたFTP/SFTPサポートでリモートファイル/フォルダを比較、同期しましょう',
    ch: '用整合 FTP/SFTP 支援比较和同步远端文件和目录',
    cht: '透過整合的 FTP/SFTP 支援來比對及同步遠端檔案及資料夾'
  },

  f_FTP: {
    en: '<span class="appname"></span>\'s FTP/SFTP directory compare allows you to access remote files and folders located on a server. Execute a directory compare and sync your remote files and directories with your local copies. Compare, merge, and save... it\'s that easy!',
    ptb: 'A comparação com o diretório FTP/SFTP <span class="appname"></span> lhe possibilita acessar arquivos e pastas remotos em um servidor. Execute uma comparação entre diretórios e sincronize seus arquivos e diretórios remotos com as suas cópias locais. Compare, mescle e salve... é fácil assim!',
    de: '<span class="appname"></span>s FTP/SFTP-Verzeichnisvergleich erm&ouml;glicht einen direkten Zugriff auf entfernte Dateien und Ordner. Starten Sie einen Verzeichnisvergleich und synchronisieren Sie Ihre lokalen Kopien mit der Versionen im Netz. Vergleichen, &Uuml;bernehmen, Sichern &ndash; so einfach ist das!',
    fr: 'La comparaison par FTP/SFTP d\'<span class="appname"></span> vous permet d\'acc&eacute;der aux fichiers/dossiers distants situ&eacute;s sur un serveur. Ex&eacute;cutez une comparaison de dossiers et synchronisez vos fichiers/dossiers distants avec vos copies locales. Comparer, fusionner, enregistrer... tout simplement !',
    es: 'La comparaci&oacute;n de directorios FTP/SFTP de <span class="appname"></span> le permite acceder a archivos y carpetas remotos ubicados en un servidor.  Ejecute una comparaci&oacute;n y sincronizaci&oacute;n de sus archivos y directorios remotos con respecto a los locales. Comparar, combinar y salvar ... &iexcl;as&iacute; de f&aacute;cil!',
    it: 'Il confronto cartelle FTP/SFTP di <span class="appname"></span> ti permette di accedere a file e cartelle memorizzati in un server remoto. Esegui un confronto cartelle e sincronizza i tuoi file e cartelle remoti con le tue copie locali. Confronta, unisci e salva... troppo facile!',
    ko: '<span class="appname"></span>의 FTP/SFTP 디렉토리 비교는 연결된 서버의 원격 파일과 폴더에 접속할 수 있습니다. 디렉토리 비교를 실행하고 원격 파일과 디렉토리를 동기화합니다. 비교, 병합 그리고 저장을 쉽게 할 수 있습니다!',
    jp: '<span class="appname"></span>のFTP/SFTP ディレクトリ比較は、サーバ上のリモートファイル/フォルダへのアクセスを可能にします。ディレクトリ比較を実行してあなたのリモートファイル/ディレクトリをローカルコピーと同期させましょう。比較、マージ、それから保存... とても簡単です！',
    ch: '<span class="appname"></span>\ 的 FTP/SFTP 目录比较让你访问在服务器的远端文件和目录。执行目录比较和同不你的远端文件和目录。比较、合并和保存... 很容易!',
    cht: '<span class="appname"></span> 的 FTP/SFTP 目錄比對可以讓你存取位於遠端伺服器中的檔案及資料夾。執行一個目錄比對並將你的本機與遠端檔案及目錄同步、比對、合併、及儲存...就是這麼簡單！'
  },

  f_SessionsHead: {
    en: 'Manage multiple compare sets with Sessions',
    ptb: 'Gerencie diversos conjuntos de comparação em sessões',
    de: 'Mehrere Vergleichsvorg&auml;nge mit Sitzungen verwalten',
    fr: 'Comparaisons simultan&eacute;es avec les sessions',
    es: 'Gestione m&uacute;ltiples tarea de comparaci&oacute;n con las Sesiones',
    it: 'Gestisci set multipli di confronto con le Sessioni',
    ko: '세션을 이용한 다중 비교 설정 관리',
    jp: '比較ペイン中のテキストをダイレクトに編集',
    ch: '用对话管理多个比较组合',
    cht: '以階段作業管理多重比對集'
  },

  f_Sessions: {
    en: 'Opening multiple instances of any application makes it harder to work, so <span class="appname"></span> gives you <strong>sessions</strong> to simplify your compare operations!<br><br>Sessions allow you to work with multiple compare sets &ndash; regardless of mode &ndash; all within one application. The tabbed interface allows you to easily toggle between multiple sessions for easier and more intuitive compare operations.',
    ptb: 'Abrir diversas instâncias de qualquer aplicativo dificulta o trabalho. Por isso, o <span class="appname"></span> oferece <strong>sessões</strong> para simplificar as suas operações de comparação!<br><br>As sessões permitem que você trabalha com diversos conjuntos de comparação &ndash; independentemente do modo &ndash; tudo em um só aplicativo. A interface com guias lhe possibilita alternar facilmente entre diversas sessões, para realizar operações de comparação mais fáceis e intuitivas.',
    de: 'Weil das &Ouml;ffnen von mehreren Instanzen des gleichen Programms die Arbeit erschwert, bietet <span class="appname"></span> Sitzungen, um Ihre Vergleichsvorg&auml;nge zu vereinfachen.<br><br>Sitzungen erlauben es, mit mehreren Vergleichsmengen innerhalb der gleichen Anwendung unabh&auml;ngig vom jeweiligen Vergleichsmodus zu arbeiten. In der Register-Ansicht k&ouml;nnen Sie auf einfache Weise zwischen den verschiedenen Sitzungen wechseln, um Ihre Vergleichsvorg&auml;nge schnell und intuitiv zu erledigen.',
    fr: 'Ouvrir plusieurs instances d\'une application complique la t&acirc;che, c\'est pourquoi <span class="appname"></span> offre des sessions pour simplifier vos op&eacute;rations de comparaison !<br><br>Les sessions vous permettent d\'effectuer types de comparaison, le tout dans une seule application. L\'interface, sous forme d\'onglets, facilite la navigation entre les sessions et rend les op&eacute;rations de comparaison plus intuitives et simples.',
    es: 'Tener que abrir varias instancias de una aplicaci&oacute;n hacen complicado su uso, &iexcl;por eso <span class="appname"></span> le ofrece sesiones que simplifican sus operaciones de comparaci&oacute;n!<br><br>Las sesiones le permiten trabajar con m&uacute;ltiples series de comparaci&oacute;n - con independencia del modo - dentro de una &uacute;nica aplicaci&oacute;n. El interfaz de pesta&ntilde;as le permite cambiar f&aacute;cil e intuitivamente entre las m&uacute;ltiples sesiones de comparaci&oacute;n.',
    it: 'Istanze multiple di una applicazione rendono il lavoro difficile: <span class="appname"></span> ti offre le sessioni per semplificare le tue operazioni di confronto!<br><br>Le Sessioni ti permettono di lavorare con gruppi di opzioni di confronto - indipendentemente dalla modalità - nella stessa applicazione. L\'interfaccia a schede ti permette di passare facilmente tra le sessioni per operazioni di confronto intuitive.',
    ko: '일반적으로 프로그램의 다중 인스턴스 열기는 상당히 어렵습니다, 그래서 <span class="appname"></span>는 간단하게 비교 작업을 하기 위해 사용자에게 세션을 부여합니다!<br><br>세션은 모드에 상관없이 한 프로그램 내에서 다중 비교 설정을 할 수 있습니다. 더 쉽고, 더 직관적인 비교를 하기 위해 탭 인터페이스를 이용하여 다중 세션 사이를 쉽게 전환할 수 있습니다.',
    jp: '相違点のマージよりもさらに多くのことしなくてはならない場合があります...たとえば、ファイルをダイレクトに編集したい場合です！すばやいテキスト編集はあなたのワークフローを改善するのに大いに役立ちます。<br><br>テキスト比較はあなたのファイルを直接編集する二つの方法を提供します: 比較ペイン中で直接編集するか、アプリケーション下段のアクティブ行ウィンドウで編集するかのどちらかです。ペイン中でダイレクトに編集するには、単にペインをクリックして、タイプすればOK... とても簡単です！',
    ch: '开多个应用程序对你工作有影响，所以 <span class="appname"></span> 给你对话，让你简化比较!<br><br>对话让你管理多个比较组合 - 不论何方式 - 全在一个应用程序。 标签界面让你容易地切换多个对话。',
    cht: '開啟多個任何應用程式的實例來增加效率。因此 <span class="appname"></span> 提供了階段作業以簡化你的比對作業！<br><br>階段作業可以讓你同時進行多重比對 - 不牽涉到模式 - 全部都在一個應用程式中。這個標籤介面可以讓你簡單的在多個階段作業間切換，簡單且更直覺的比對作業。'
  },

  f_CompareArchivesHead: {
    en: 'Compare .zip, .jar, and .rar archives',
    ptb: 'Compare arquivos .zip, .jar, e .rar',
    de: 'Vergleichen Sie .ZIP-, .JAR- und .RAR-Archive',
    fr: 'Comparer des archives .zip, .jar et .rar',
    es: 'Compare archivadores .zip, .jar, y .rar',
    it: 'Confronta archivi .zip, .jar e .rar',
    ko: '아카이브 비교는 .zip, .jar, .rar',
    jp: '圧縮ファイル比較で .zip, .jar, さらに.rar',
    ch: '用存档比较比较 .zip、.jar和 .rar',
    cht: '以壓縮套件比對來比對 .zip, .jar, 及 .rar'
  },

  f_CompareArchives: {
    en: 'Got archives? <span class="appname"></span>\'s archive compare allows you to compare the contents of .zip, .rar, and Java .jar archives.<br><br>Use the archive compare and examine differences between archives or folders on the file system. And best of all... the archive compare feature is easy-to-use!',
    ptb: 'Você tem arquivos? A comparação de arquivos do <span class="appname"></span>lhe permite comparar o conteúdo de arquivos .zip, .rar e Java (.jar).<br><br>Use a comparação de arquivos e examine diferenças entre arquivos ou pastas em seu sistema de arquivos. E o melhor de tudo: o recurso de comparação é fácil de usar!',
    de: 'M&uuml;ssen Sie Archive vergleichen? Das ist kein Problem mit <span class="appname"></span> &ndash; .ZIP-, .RAR- und Java .JAR-Archive werden verarbeitet.<br><br>Unterschiede zwischen Archiven und/oder Ordnern im Dateisystem k&ouml;nnen Sie mit &raquo;Archive vergleichen&laquo; aufsp&uuml;ren. Vor allem noch: diese Funktion ist leicht zu bedienen!',
    fr: 'Vous avez des archives ? L\'outil de comparaison d\'archives d\'<span class="appname"></span> vous permet de comparer le contenu d\'archives .zip, .rar et Java .jar.<br><br>Utilisez cet outil pour examiner les diff&eacute;rences entre des archives et des dossiers du syst&egrave;me de fichiers. Et pour couronner le tout... la fonction de comparaison des archives est facile &agrave; utiliser !',
    es: '&iquest;Ha recibido un archivador?  La comparaci&oacute;n de archivadores de <span class="appname"></span> le permite comparar el contenido de los archivadores .zip, .rar, y .jar de Java.<br><br>Use la comparaci&oacute;n de archivadores y examine las diferencias entre los archivos y carpetas del sistema de archivos.  Y lo mejor de todo... &iexcl;la comparaci&oacute;n de archivadores es f&aacute;cil de usar!',
    it: 'Il confronto degli archivi di <span class="appname"></span> ti permette di confrontare il contenuto di file .zip, .rar e archivi .jar Java.<br><br>Utilizza il confronto degli archivi ed esamina le differenze tra archivi o cartelle nel file system.  Ma soprattutto... il confronto degli archivi è semplicissimo da usare!',
    ko: '압축파일이 있습니까? <span class="appname"></span>의 아카이브 비교는 .zip, .rar, 그리고 Java .jar 압축파일의 내용을 비교할 수 있습니다.<br><br>아카이브 비교를 사용하면, 파일 시스템에서 압축파일과 폴더간의 차이를 검사합니다.  그리고 아카이브 비교의 특징중에 가장 주요한 것은 쉽게 사용할 수 있다는 것입니다!',
    jp: '圧縮ファイルをお持ちですか？ <span class="appname"></span>の圧縮ファイル比較は .zip, .rarの内容, さらに Java .jarファイルさえも比較することができます！<br><br>圧縮ファイル比較は上記の一般的なフォーマットをサポートするだけではなく、パスワードでプロテクトされた.zip ファイルさえも比較することができます！',
    ch: '有存档?  <span class="appname"></span> 的存档比较让你比较.zip、.rar 和 Java .jar 存档的内容。<br><br>利用存档比较和检查在文件系统上的存档和目录。存档比较很容易-to-use!',
    cht: '有壓縮套件嗎？<span class="appname"></span> 的壓縮套件比對可以讓你比對 .zip, .rar, 及 Java .jar 壓縮套件的內容。<br><br>使用這個壓縮套件比對並檢查壓縮套件或資料夾間檔案系統的差異。而更好是...這個壓縮套件比對功能相當容易使用！'
  },

  f_DocPDFHead: {
    en: 'Compare Word, RTF, and PDF files in a snap!',
    ptb: 'Compare arquivos Word, RTF e PDF em instantes!',
    de: 'Word-Dokumente und RTF-Dateien vergleichen',
    fr: 'Comparez les documents Word et fichiers RTF',
    es: 'Compare archivos de Documentos Word y RTF',
    it: 'Confronto di Documenti Word e file RTF',
    ko: '워드 문서와 RTF 파일을 비교합니다',
    jp: 'ワード文書、リッチテキストファイルの比較',
    ch: '比较 Word Docs 和 RTF 文件',
    cht: '比對 Word 文件及 RTF 檔案'
  },

  f_DocPDF: {
    en: '<span class="appname"></span> supports compare and merge operations for Microsoft Word Documents, RTF files, and PDF documents.<br><br>If you need to see what\'s been changed on your contracts, papers, and more... then <span class="appname"></span>\'s Word Doc compare is what you\'re looking for!',
    ptb: 'O <span class="appname"></span> oferece suporte a operações de comparação e mesclagem para documentos do Microsoft, arquivos RTF e PDF.<br><br>Se você precisa ver o que foi alterado em seus contratos, artigos técnicos e outros documentos... a comparação de arquivos do Word do <span class="appname"></span> é o que você está procurando!',
    de: 'Arbeiten Sie mit Anderen am gleichen Word-Dokument zusammen? Verfolgen Sie alle &Auml;nderungen auf einfache Weise mit <span class="appname"></span>.<br><br><span class="appname"></span> unterst&uuml;tzt Vergleiche und &Uuml;bernahmevorg&auml;nge f&uuml;r Microsoft Word-Dokumente und Dateien im RTF-Format. Wenn Sie &Auml;nderungen in Ihren Vertr&auml;gen, Unterlagen, usw. verfolgen m&uuml;ssen, ist die Funktion &raquo;Word-Dokumentvergleich&laquo; genau das Richtige f&uuml;r Sie!',
    fr: 'Vous travaillez &agrave; plusieurs sur un document Word ? Suivez simplement toutes les modifications de vos collaborateurs avec <span class="appname"></span>.<br><br><span class="appname"></span> permet la comparaison et la fusion des documents Microsoft Word et des fichiers RTF. Si vous avez besoin de voir ce qui a &eacute;t&eacute; chang&eacute; dans vos contrats, papiers, etc., vous avez trouv&eacute; l\'outil qu\'il vous fallait !',
    es: '&iquest;Tiene un Documento Word en el que colabora con otras personas? Siga f&aacute;cilmente los cambios entre todas las partes con <span class="appname"></span>.<br><br><span class="appname"></span> soporta la comparaci&oacute;n y combinaci&oacute;n de archivos de Documentos Microsoft Word y RTF. Si necesita ver los cambios en sus contratos, papeles, y m&aacute;s... &iexcl;entonces la comparaci&oacute;n de Documentos Word de <span class="appname"></span> es lo que est&aacute; buscando!',
    it: 'Hai un documento Word condiviso con altri per lavoro? Traccia facilmente le modifiche fatte da altri con <span class="appname"></span>.<br><br><span class="appname"></span> supporta il confronto e l\'unione tra file Microsoft Word e file RTF. Se vuoi vedere cosa è stato modificato nei tuoi contratti, lavori o altro...  allora il confronto Word di <span class="appname"></span> è quello che stai cercando!',
    ko: '다른 사람들과 공동 작업중인 워드 문서가 있습니까? <span class="appname"></span>는 쉽게 변경된 부분을 모두 찾아줍니다.<br><br><span class="appname"></span>  마이크로소프트 워드 문서와 RTF 파일을 비교하고 병합할 수 있습니다. 계약서나 서류 등과 같은 문서에서 변경된 것이 무엇인지 알고 싶다면...  <span class="appname"></span> 워드 문서 비교가 당신이 찾고 있는 것입니다!',
    jp: '他の人と共有して編集しているワード文書をお持ちですか? <span class="appname"></span>で全てのパーティ間の全ての変更を簡単にトラッキングしましょう。<br><br><span class="appname"></span>はMicrosoft Word 文書とリッチテキスト(RTF)ファイルの比較、マージ機能をサポートしています。あなたの契約書、論文、その他文書のどこが変更されたのか知りたい場合...  <span class="appname"></span>の ワード文書比較こそあなたの求めていたものでしょう！',
    ch: '你有一个 Word 文件跟其他人协作吗? 容易地跟踪所有的改变。<br><br><span class="appname"></span> 专业版支持 Microsoft 和 RTF 文件的比较和合并。如果你有知道你作的改变，<span class="appname"></span>\ 的 Word Doc 比较是你想的!',
    cht: '有與其他人協同作業的 Word 文件？有了 <span class="appname"></span> 可以簡單的追蹤所有部份的所有變更。<br><br><span class="appname"></span> 支援比對及合併 Microsoft Word 文件及 RTF 檔案的作業。如果你必須知道你的合約、論文等變更了什麼...則 <span class="appname"></span> 的 Word 文件比對正是你所需要的。'
  },

  f_VersionControlHead: {
    en: 'Use <span class="appname"></span> to diff and merge from Git, Subversion, CVS, and more',
    ptb: 'Use <span class="appname"></span> to diff and merge from Git, Subversion, CVS, and more',
    de: 'Mit <span class="appname"></span> Diff- und Merge-Funktionen von Git, Subversion, CVS und anderen Systemen aus ausführen',
    fr: 'Utilisez <span class="appname"></span> pour effectuer une différenciation / fusion depuis Git, Subversion, CVS, et bien d\'autres.',
    es: 'Utilice <span class="appname"></span> para establecer las diferencias y combinar desde Git, Subversion, CVS y mucho más',
    it: 'Utilizzare <span class="appname"></span> per differenziare ed unire da Git, Subversion, CVSe molto altro ancora',
    ko: '<span class="appname"></span> 앱을 이용해서 Git, Subversion, CVS 등에서 비교하고 병합할 수 있습니다',
    jp: '<span class="appname"></span>を使用して、Git、Subversion、CVSなどを比較およびマージします',
    ch: '使用 <span class="appname"></span> 区分和合并 Git、Subversion、CVS 等',
    cht:    '使用<span class="appname"></span>來區分及合併 Git、Subversion、CVS 與更多內容'
  },

  f_VersionControl: {
    en: 'You can use <span class="appname"></span> as your diff or merge tool for your preferred version control system &ndash; Git, Subversion, CVS, Perforce and many other popular version control systems!<br><br><span class="appname"></span> includes the command line functionality required for these systems.  With a minor tweak to your system\'s configuration, you can diff and merge files in <span class="appname"></span> directly from your version control.',
    ptb: 'Você pode usar o <span class="appname"></span> como ferramenta de comparação ou mesclagem para seu sistema de controle de versões preferido &ndash; Git, Subversion, CVS, Perforce e muitos outros dos sistemas de controle de versão mais difundidos no mercado! O <br><br><span class="appname"></span> inclui a funcionalidade de linha de comando exigida para trabalhar nesses sistemas.  Com um pequeno ajuste na configuração do seu sistema, você pode comparar e mesclar arquivos no <span class="appname"></span> diretamente de sua ferramenta de controle de versões.',
    de: 'Sie können <span class="appname"></span> als Diff- und Merge-Tool in Ihrem bevorzugten Versionskontrollsystem &ndash; Git, Subversion, CVS, Perforce und vielen anderen gängigen Systemen &ndash; einsetzen.<br><br><span class="appname"></span> enthält die für diese Systeme erforderliche Befehlszeilenfunktion.  Nach einer geringfügigen Änderung in Ihrer Systemkonfiguration können Sie Dateien in <span class="appname"></span> direkt von Ihrem Versionskontrollsystem aus vergleichen und zusammenführen.',
    fr: 'Vous pouvez utiliser <span class="appname"></span> en tant qu\'outil Diff/Fusion pour votre système de contrôle des versions favori &ndash; Git, Subversion, CVS, Perforce ainsi que de nombreux autres systèmes répandus !<br><br><span class="appname"></span> intègre la fonction de ligne de commande que requièrent ces systèmes.  Une modification mineure de la configuration de votre système vous permet de différencier et de fusionner des fichiers dans <span class="appname"></span> directement depuis votre contrôle des versions.',
    es: 'Puede usar <span class="appname"></span> como herramienta de diferenciación y combinación en su sistema de control de versiones preferido &ndash; Git, Subversion, CVS, Perforce y muchos otros sistemas populares de control de versiones.<br><br><span class="appname"></span> incluye la funcionalidad de línea de comandos requerida por estos sistemas.  Con un mínimo cambio en la configuración del sistema, puede establecer las diferencias y combinar archivos en <span class="appname"></span> directamente desde su control de versiones.',
    it: 'L\'applicazione <span class="appname"></span> può essere utilizzata come strumento di differenziazione o unione per il proprio sistema di controllo versione preferito &ndash; Git, Subversion, CVS, Perforce e molti altri sistemi di controllo versione!<br><br><span class="appname"></span> include la funzionalità delle righe di comando per questi sistemi.  Con una leggera modifica della configurazione del proprio sistema è possibile differenziare ed unire più file in <span class="appname"></span> direttamente dal proprio sistema di controllo versione.',
    ko: '<span class="appname"></span> 앱을 버전 컨트롤 시스템 &ndash; Git, Subversion, CVS, Perforce 및 다른 많은 버전 컨트롤 시스템 등에 사용할 비교 또는 병합 도구로 사용할 수 있습니다!<br><br><span class="appname"></span> 앱에는 이들 시스템에 필요한 명령줄 기능이 포함되어 있습니다.  시스템 설정을 약간 변경해서 버전 컨트롤로부터 직접 <span class="appname"></span> 앱에서 파일을 비교 및 병합할 수 있습니다.',
    jp: '希望のバージョンコントロールシステム（Git、Subversion、CVS、Perforce、およびその他の多数の一般的なバージョンコントロールシステム）のための比較またはマージツールとして<span class="appname"></span>を使用することができます。<br><br><span class="appname"></span>には、これらのシステムに必要なコマンドライン機能が含まれます。システムの構成への微調整により、バージョンコントロールから直接<span class="appname"></span>内のファイルを比較またはマージすることができます。',
    ch: '您可以使用 <span class="appname"></span> 作为您的首选版本控制系统（Git、Subversion、CVS、Perforce 及许多其他受欢迎的版本控制系统）的区分或合并工具！<br><br><span class="appname"></span> 包括这些系统所需的命令行功能。对您的系统配置进行小幅调整，您就可以直接从版本控制区分或合并 <span class="appname"></span> 中的文件。',
    cht:    '您可以使用<span class="appname"></span>做為您偏好的版本控制系統的區分及合併工具 &ndash; Git、Subversion、CVS、Perforce 以及許多其他受歡迎的版本控制系統！<br><br><span class="appname"></span> 包含了這些系統所要求的命令行功能。只需要稍微調整您系統的組態，您就可以直接從您的版本控制中區分與合併<span class="appname"></span>的檔案。'
  },

  f_QuickDiffHead: {
    en: 'Perform a command line quick diff to compare your files without launching <span class="appname"></span>',
    ptb: 'Você também pode fazer uma comparação rápida de linha de comando sem abrir o <span class="appname"></span>',
    de: 'Vergleichen Sie Ihre Dateien von der Befehlszeile aus, ohne <span class="appname"></span> starten zu m&uuml;ssen',
    fr: 'Effectuez une comparaison rapide des diff&eacute;rences via la ligne de commandes pour comparer vos fichiers sans lancer <span class="appname"></span>.',
    es: 'Realice una comparaci&oacute;n de diferencias r&aacute;pida de sus archivos en l&iacute;nea de comando sin necesidad de lanzar <span class="appname"></span>',
    it: 'Effettua un confronto veloce dei tuoi file da riga di comando senza lanciare <span class="appname"></span>',
    ko: '<span class="appname"></span>를 시작하지 않고 빠르게 차이를 비교하기 위해 명령어 라인을 실행합니다.',
    jp: '<span class="appname"></span>を起動することなくコマンドラインで高速にファイルを比較します。',
    ch: '执行命令行分别快检查，不用打开 <span class="appname"></span> 比较你的文件',
    cht: '執行命令列快速差異來比對你的檔案而不需啟動 <span class="appname"></span>'
  },

  f_QuickDiff: {
    en: 'The Quick Difference checks your files to see if they are different without showing the GUI &ndash; making the compare ultra-fast.<br><br>If you need to quickly check whether your files are different, without needing to see where the differences are, then this is one command you want in your arsenal.',
    ptb: 'O Quick Difference verifica seus arquivos para ver se eles são diferentes sem mostrar a GUI &ndash; o que torna a comparação ultrarrápida.<br><br>Se precisar verificar se os seus arquivos são diferentes sem precisar ver as diferenças, esse é o comando único que você precisa ter em seu arsenal.',
    de: 'Der &raquo;Schneller Befehlszeilenvergleich&laquo; pr&uuml;ft, ob Ihre Dateien sich unterscheiden, ohne die GUI anzuzeigen - deshalb ist der Vergleich superschnell!<br><br>Wenn Sie lediglich feststellen m&uuml;ssen, ob die Dateien gleich sind ohne genau die Unterschiede zu besichtigen, werden Sie diesen Befehl nicht vermissen wollen!',
    fr: 'La comparaison rapide v&eacute;rifie vos fichiers afin de voir s\'ils sont diff&eacute;rents sans afficher l\'interface – ce qui rend la comparaison extr&ecirc;mement rapide !<br><br>Si vous avez besoin de v&eacute;rifier rapidement si vos fichiers pr&eacute;sentent des diff&eacute;rences sans n&eacute;cessairement conna&icirc;tre la nature de ces diff&eacute;rences, voil&agrave; une commande qui doit imp&eacute;rativement figurer dans votre arsenal !',
    es: 'La Verificaci&oacute;n R&aacute;pida de Diferencias busca en sus archivos las diferencias sin mostrar un interfaz gr&aacute;fico - &iexcl;haciendo la comparaci&oacute;n ultra-r&aacute;pida!<br><br>Si usted necesita verificar r&aacute;pidamente si hay diferencias en sus archivos, sin necesidad de verlas, entonces &iexcl;este es uno de los comandos que usted querr&aacute; en su arsenal!',
    it: 'Le Differenze Veloci verificano i tuoi file per trovare le differenze senza un GUI - rendendo il confronto super-veloce!<br><br>Se hai bisogno di controllare velocemente se i tuoi file sono differenti, senza aver bisogno di vedere quali sono le differenze, allora questo è il comando che devi utilizzare per forza!',
    ko: 'GUI없이 가장 빠른 비교로 파일에 차이가 있는지 확인하기 위해 빠른 차이 검사를 합니다!<br><br>어느 부분에 차이가 있는지는 확인할 필요없이, 사용자의 파일에 차이가 있는지 없는지를 빨리 검사하기를 원한다면, 이것이 바로 사용자가 원하는 명령어입니다!',
    jp: '相違点チェック（クイック）はあなたのファイルが異なるものかどうかをGUIを表示することなくチェックします - 比較作業が大幅に早くなります！<br><br>任意のファイルが、どこが異なるかは関係なく、異なるものかどうかすぐにチェックしたい場合、このコマンドはあなたの強力な武器の一つとなるでしょう！',
    ch: '命令行分别快检查你的文件的分别，不用显示 GUI - 令比较特别快!<br><br>如果你需要检查你的文件是否不同，不用知道他们的分别，你可以用一个命令行!',
    cht: '這個快速差異可檢查你的檔案是否不同而且不需要顯示 GUI - 讓比對更快！<br><br>如果你需要快速檢查你的檔案是否有不同但不用知道不同在哪裏，那麼這個單一命令就是你要的武器！'
  },

  f_InlineEditingHead: {
    en: 'Edit text directly in the compare panes',
    ptb: 'Edite texto diretamente nos painéis de comparação',
    de: 'Text direkt in den Vergleichsanzeigen bearbeiten',
    fr: 'Modifiez le texte directement dans les panneaux de comparaison',
    es: 'Edite el texto directamente en los paneles de comparaci&oacute;n',
    it: 'Modifica il testo nei pannelli di confronto',
    ko: '비교창에서 직접 텍스트 편집',
    jp: '比較ペイン中のテキストをダイレクトに編集',
    ch: '在比较窗格中直接编辑文本',
    cht: '直接在比對窗格中編輯文字'
  },

  f_InlineEditing: {
    en: 'While you can edit your files in <span class="bdlname"></span> and merge differences in <span class="appname"></span>, sometimes you need to make a quick change to the file directly in the compare frame. Editing text on the fly is essential in a text compare app.<br><br><span class="appname"></span> offers two ways to directly edit your files: editing directly in the compare panes or double clicking to edit in the active line window at the bottom of the application. It\'s that easy!',
    ptb: 'Embora você possa editar arquivos no UltraEdit e mesclar diferenças no <span class="appname"></span>, às vezes você precisa fazer uma alteração rápida em um arquivo diretamente no quadro de comparação. Você conseguir editar texto enquanto desenvolve a sua atividade é um recurso essencial em um aplicativo. O <br><br><span class="appname"></span> oferece duas maneiras de editar arquivos diretamente: nos painéis de comparação ou clicando duas vezes no botão esquerdo do mouse para editar na janela de linha ativa, na parte inferior do aplicativo. É fácil assim!',
    de: 'Während der Bearbeitung von Dateien in <span class="bdlname"></span> und der Zusammenführung von Unterschieden in <span class="appname"></span> ist es manchmal erforderlich, kleine Änderungen an der Datei direkt im Vergleichsrahmen vorzunehmen. Die Möglichkeit der unmittelbaren Textbearbeitung ist für ein Textvergleichsprogramm unerlässlich.<br><br>Mit <span class="appname"></span> können Sie dies auf zwei Weisen machen: direkt im Vergleichsrahmen oder im Fenster mit der aktiven Zeile unten im Programm durch Doppelklicken. So einfach ist das!',
    fr: 'Lorsque vous modifiez vos fichiers dans <span class="bdlname"></span> et fusionnez les différences dans <span class="appname"></span>, vous avez parfois besoin d\'apporter une modification rapide au fichier directement dans le cadre de comparaison. La modification du texte à la volée est essentielle dans une application de comparaison de texte.<br><br><span class="appname"></span> offre deux manières de modifier directement vos fichiers : modification directe dans les volets de comparaison ou via un double-clic dans la fenêtre de ligne active au bas de l\'application. C\'est facile !',
    es: 'Aunque puede editar archivos en <span class="bdlname"></span> y combinar las diferencias en <span class="appname"></span>, a veces es preciso realizar un cambio rápido directamente en el archivo en el marco de la comparación. La edición de textos sobre la marcha es un proceso esencial en una aplicación de comparación de textos.<br><br><span class="appname"></span> ofrece dos formas de editar directamente los archivos: la edición directa en los paneles de comparación o hacer doble clic para editar la ventana de la línea activa en la parte inferior de la aplicación. ¡Es muy sencillo!',
    it: 'Mentre è possibile modificare i propri file con <span class="bdlname"></span> ed unire le differenze con <span class="appname"></span>, a volte è necessario poter fare delle rapide modifiche al file direttamente dal riquadro di confronto. La modifica rapida di un testo è essenziale per un\'applicazione di confronto testi.<br><br><span class="appname"></span> offre due modi per modificare i propri file: modificarli direttamente nel riquadro di confronto oppure fare doppio clic con il mouse nella finestra attiva nella parte inferiore dell\'applicazione. È un gioco da ragazzi!',
    ko: '<span class="bdlname"></span>에서 파일을 편집하고 <span class="appname"></span> 앱에서 차이를 병합하는 동안 어떤 경우에는 비교  프레임에서 직접 파일을 신속하게 변경할 필요가 있습니다. 즉시 텍스트를 편집할 수 있는 기능은 텍스트 비교 앱의 필수 기능입니다.<br><br><span class="appname"></span> 앱에서는 두 가지 방법으로 파일을 직접 편집할 수 있습니다. 즉, 비교 창에서 직접 편집하거나 애플리케이션 하단의 현재 줄 창을 더블 클릭해서 편집할 수 있습니다. 매우 간편합니다!',
    jp: '<span class="bdlname"></span>でファイルを編集でき、また<span class="appname"></span>で差分をマージすることができますが、時には比較フレーム内で直接ファイルにすばやく変更を行うことが必要になります。オンザフライのテキストの編集は、テキスト比較アプリで不可欠です。<br><br><span class="appname"></span>では、ファイルを直接編集するために、次の2つの方法を提供します。比較ペイン内での直接の編集、またはダブルクリックして、アプリケーションの下部のアクティブなラインウィンドウ内で編集。それは非常に簡単です！',
    ch: '您可以在 <span class="bdlname"></span> 中编辑文件，并在 <span class="appname"></span> 中合并差异，有时，您需要直接在比较框中对文件进行快速更改。在运行中编辑文本在文本比较应用程序中是必不可少的。<br><br><span class="appname"></span> 可提供两种直接编辑文件的方式：直接在比较窗格中编辑，或者双击以在应用程序底部的活动行窗口中进行编辑。非常简单！',
    cht:    '雖然您可以在 <span class="bdlname"></span> 中編輯檔案，並在<span class="appname"></span>內合併差異，但有時候您需要在比較框架內直接對檔案進行快速變更。。在文字比較應用程式中，快速編輯文字的功能是很重要的。<br><br><span class="appname"></span>共提供兩種可直接編輯檔案的方式：直接在比較窗格內編輯，或者在位於應用程式底部的作用中行上按兩下以編輯。就是這麼簡單！'
  },

  f_IgnoreOptionsHead: {
    en: 'Only compare what\'s important by using ignore options',
    ptb: 'Compare só o que é importante usando as opções Ignorar',
    de: 'Mit Optionen zum Ignorieren nur das wirklich Wichtige vergleichen',
    fr: 'Ne comparez que ce qui est important en utilisant les options d\'outrepassement qui permettent d\'ignorer certains éléments',
    es: 'Compare únicamente lo que es importante mediante el uso de las opciones de ignorar',
    it: 'Confronta solo ciò che è veramente importante, usando le opzioni della funzionalità Ignora',
    ko: '무시 옵션을 이용해서 중요한 것들만 비교할 수 있습니다',
    jp: '無視オプションを使用することにより、重要なことだけを比較します',
    ch: '使用忽略选项，只比较重要项目',
    cht:    '使用忽略選項，僅比較重要的項目'
  },

  f_IgnoreOptions: {
    en: 'Want to ignore differences in comments when comparing source files?  Need to ignore a specific number of lines at the beginning or end of the file?  Want to ignore differences in spaces, tabs, or line endings? Ignore options make this all possible.  To set ignore options for your compare, go to <strong>Session</strong> -> <strong>Session Properties</strong>, make the changes you want, then click <strong>OK and Run</strong>.',
    ptb: 'Deseja ignorar diferenças em comentários ao comparar arquivos de origem?  Precisa ignorar um número específico de linhas no início ou no fim do arquivo?  Deseja ignorar diferenças em espaços, guias ou fins de linha? Tudo isso é possível com as opções Ignorar.  Para definir as opções Ignorar para a sua comparação, vá para <strong>Sessão</strong> -> <strong>Propriedades da sessão</strong>, faça as alterações que desejar e clique em <strong>OK e Executar</strong>.',
    de: 'Möchten Sie beim Vergleich von Quelldateien Unterschiede in Kommentaren ignorieren?  Oder ein bestimmte Anzahl von Zeilen am Anfang oder Ende der Datei?  Oder Unterschiede bei Leerzeichen, Tabulatoren oder Zeilenendezeichen? Mit Optionen zum Ignorieren geht all dies ganz einfach.  Gehen Sie dazu zu <strong>Sitzung</strong> -> <strong>Sitzungseigenschaften</strong>, nehmen Sie die gewünschten Änderungen vor und klicken Sie dann auf <strong>OK und Ausführen/strong>.',
    fr: 'Vous souhaitez ignorer les différences dans les commentaires lorsque vous comparez des fichiers source ?  Vous avez besoin d\'ignorer un nombre spécifique de lignes au début et à la fin du fichier ?  Vous souhaitez ignorer les différences au niveau des espaces, des retraits ou des fins de ligne ? Les options d\'outrepassement le permettent.  Pour définir les options d\'outrepassement dans votre comparaison, ouvrez <strong>Session</strong> -> <strong>Propriétés de la session</strong>, apportez les modifications souhaitées, puis cliquez sur <strong>OK et Exécuter</strong>.',
    es: '¿Desea ignorar las diferencias en comentarios cuando se comparan archivos de origen?  ¿Debe ignorar un número específico de líneas al comienzo o al final del archivo?  ¿Desea ignorar las diferencias en espacios, tabuladores o fin de líneas? Las opciones de ignorar lo hacen posible.  Para establecer las opciones de ignorar en la comparación, vaya a <strong>Sesión</strong> -> <strong>Propiedades de la sesión</strong>, realice los cambios deseados y, a continuación, haga clic en <strong>Aceptar y ejecutar</strong>.',
    it: 'Desideri che vengano ignorate le differenze nei commenti durante il confronto con i file sorgente?  Hai bisogno di ignorare un numero specifico di righe all\'inizio o alla fine del file?  Desideri ignorare le differenze in termini di spazi, tabulazioni o fine riga? Le opzioni della funzionalità Ignora possono rendere tutto questo possibile.  Per impostare le opzioni della funzionalità Ignora per il confronto, andare in <strong>Sessione</strong> -> <strong>Proprietà sessione</strong>, eseguire le modifiche che si desidera, quindi cliccare su <strong>OK e Esegui</strong>.',
    ko: '소스 파일들을 비교할 때 주석의 차이를 무시하고 싶습니까?  파일 시작 또는 끝에서 특정 라인 번호를 무시해야 합니까?  공백, 탭, 또는 줄마침 표시의 차이를 무시하고 싶습니까? 무시 옵션으로 이들 모든 작업을 수행할 수 있습니다.   비교 작업에 무시 옵션을 설정하려면 <strong>세션</strong> -> <strong>세션 속성</strong>으로 이동해서, 원하는 속성으로 변경한 후 <strong>확인 및 실행</strong>을 클릭하십시오.',
    jp: 'ソースファイルを比較するとき、コメントにおける差分を無視したいですか？ファイルの最初と最後の特定の数の行を無視する必要がありますか？スペース、タブ、または行末の差分を無視したいですか？無視オプションにより、このすべてが可能になります。比較に対して無視オプションを設定するには、<strong>セッション</strong> -> <strong>セッションのプロパティ</strong>に進み、希望の変更を行い、<strong>OKして実行</strong>をクリックします。',
    ch: '比较源文件时要忽略注释中的差异？需要忽略文件开头或末尾的特定行数？要忽略空格、标签或行尾的差异？忽略选项使这一切成为可能。若要为比较设置忽略选项，请转到<strong>会话</strong> -> <strong>会话属性</strong>，进行所需的更改，然后单击<strong>确定并运行</strong>。',
    cht:    '想要在比較來源檔案時忽略註釋中的差異？需要忽略在檔案開始或結尾處的特定行數？想要忽略空格、定位點或行結束的差異？忽略選項可實現上述功能。若要為您的比較設定忽略選項，請進入<strong>作業階段</strong> -> <strong>作業階段屬性</strong>，完成您想要的變更，然後按一下<strong>確定並執行</strong>。'
  },

  f_HTMLHead: {
    en: 'Inspect your code with HTML preview',
    ptb: 'Inspecione código com visualização de HTML',
    de: 'Pr&uuml;fen Sie Ihren Code visuell in der HTML Browser-Ansicht',
    fr: 'Contr&ocirc;lez visuellement votre code &agrave; l\'aide d\'un aper&ccedil;u HTML',
    es: 'Inspeccione visualmente su c&oacute;digo con una previsualizaci&oacute;n HTML',
    it: 'Controlla il tuo codice con l\'anteprima HTML',
    ko: 'HTML 미리보기를 이용하여 코드를 시각적으로 확인할 수 있습니다',
    jp: 'HTMLプレビューで視覚的にあなたのコードをチェックしましょう',
    ch: '利用HTML 预览器形象化地检查你的源代码',
    cht: '以一個 HTML 預覽來視覺化的審視你的原始碼'
  },

  f_HTML: {
    en: 'If you compare/merge HTML files and need to see what the changes look like in the browser, then you\'ve come to the right place!<br><br><span class="appname"></span> supports an integrated browser view in the compare panes that allows you to preview the HTML rendered as you would see it in your web browser. Simply compare, merge and/or edit, then hit the browser view for a quick visual inspection of your changes.',
    ptb: 'Se você comparar/mesclar arquivos HTML e precisar ver no navegador da Internet como ficaram as mudanças, você veio ao lugar certo! O <br><br><span class="appname"></span> oferece suporte a uma exibição integrada do navegador nos painéis de comparação que permite que você veja arquivos HTML exatamente como veria no navegador. Simplesmente compare, mescle e/ou edite e toque na visualização do navegador para inspecionar as suas alterações.',
    de: 'Wenn Sie nach einem Vergleichs- und &Uuml;bernahmevorgang von HTML-Dateien die &Auml;nderungen nachher im Browser &uuml;berpr&uuml;fen m&ouml;chten, sind Sie mit <span class="appname"></span> gut dran!<br><br><span class="appname"></span> bietet eine eingebaute Browser-Ansicht direkt in den Vergleichsanzeigefenstern, damit Sie Ihren HTML-Quelltext genauso wie im Internet-Browser ansehen k&ouml;nnen. Einfach vergleichen, &uuml;bernehmen und bearbeiten, dann schnell in die Browser-Ansicht wechseln um die &Auml;nderungen zu &uuml;berpr&uuml;fen.',
    fr: 'Si vous comparez/fusionnez des fichiers HTML et que vous avez besoin de voir les modifications engendr&eacute;es comme dans le navigateur, vous vous trouvez au bon endroit !<br><br><span class="appname"></span> propose un affichage navigateur int&eacute;gr&eacute; aux fen&ecirc;tres de comparaison qui vous permet de pr&eacute;visualiser le r&eacute;sultat HTML comme vous le verriez dans votre navigateur Web. Il vous suffit de comparer, fusionner et/ou &eacute;diter, puis de cliquer sur l\'affichage navigateur pour pouvoir examiner rapidement vos modifications.',
    es: 'Si usted compara/combina archivos HTML y necesita ver el aspecto de los cambios en un navegador, &iexcl;entonces ha llegado al sitio ideal!<br><br><span class="appname"></span> soporta un visor en navegador integrado en los paneles de comparaci&oacute;n, que le permite previsualizar el HTML tal y como lo ver&iacute;a en su navegador web. Simplemente compare, combine y edite, entonces use el visor para inspeccionar visualmente los cambios.',
    it: 'Se confronti/unisci file HTML e hai bisogno di vedere come sembrano le modifiche nel browser, allora hai scelto lo strumento giusto!<br><br><span class="appname"></span> supporta una visualizzazione browser integrata nei pannelli di confronto per vedere l\'anteprima dell\'HTML come in un vero browser. Confronta, unisci e modifica e poi usa la visualizzazione browser per vedere l\'effetto delle modifiche.',
    ko: 'HTML 파일을 비교/병합한다면, 그리고 변경된 부분을 브라우저에서 확인할 필요가 있다면, 적절한 선택을 하셨습니다!<br><br><span class="appname"></span>는 비교창에서 통합된 브라우저로 보기를 지원합니다. 사용자의 웹브라우저에서 보는 것처럼 HTML 미리보기를 할 수 있습니다. 간단하게 비교, 병합 또는 수정한 후에, 브라우저로 보기를 이용하여 변경된 부분을 빠르게 확인할 수 있습니다.',
    jp: 'HTMLファイルを比較/マージする場合、変更箇所がブラウザでどのように表示されるか、正しく表示されているかチェックする必要があるでしょう。<br><br><span class="appname"></span>は比較ペインでの統合ブラウザビューをサポートしています。それによってwebブラウザで見るのと同じようなHTMLプレビューを比較ペイン中で見ることができます。シンプルな比較から、マージさらには編集までしてブラウザビューボタンをクリックすれば変更点を視覚的に、一目で確認することができます。',
    ch: '如果你比较/合并 HTML 文件和你需要看它在浏览器变化，你是找到了对的地方!<br><br><span class="appname"></span> 支持在比较框的综合浏览器，它让你预览 生产的 HTML。比较、合并和/或编辑，然后点击浏览器视图进行快的形象化的变化检查。',
    cht: '如果你比對/合併 HTML 檔案，並且需要在瀏覽器中檢視變更的樣子，那你來對了地方！<br><br><span class="appname"></span> 在比對窗格中支援一個整合的瀏覽器檢視，可以讓你預覽 HTML 結果，就如你在你的網頁瀏覽器中所見。只需簡單的比對、合併及/或編輯，然後按下瀏覽器檢視以快速視覺化的檢查你的變更。'
  },

  f_GitIntegrationHead: {
    en: 'Integrate with Git',
    ptb: 'A integração com o Git',
    de: 'Einbindung in Git',
    fr: 'L’intégration Git',
    es: 'Integrar con Git',
    it: 'Integra con Git',
    ko: 'Git과 통합하면',
    jp: 'Git統合',
    ch: '与 Git 集成',
    cht: '與 Git 整合'
  },

  f_GitIntegration: {
    en: '<span class="appname"></span> provides an overview of all Git repos on your system, along with state and branch info.<br><br>Open the <strong>Git</strong> tab in the ribbon to toggle the repository browser, branch browser, and conflicts pane. You\'ll discover even more useful Git functionality from any of these windows or in the Git ribbon.',
    ptb: '<span class="appname"></span> oferece uma visão geral de todos os repositórios do Git no seu sistema, além de informações de estado e ramificação.<br><br>Abra a guia <strong>Git</strong> na faixa de opções para alternar o navegador do repositório, navegador da ramificação e o painel de conflitos. Você descobrirá ainda mais funcionalidades úteis do Git em qualquer uma dessas janelas ou na faixa de opções do Git.',
    de: '<span class="appname"></span> bietet eine Übersicht über alle Git-Repositorys auf Ihrem System einschließlich Informationen zu Zustand und Zweig.<br><br>Öffnen Sie im Ribbon den Reiter <strong>Git</strong>, um zum Repository-Browser, Zweig-Browser und Konflikt-Bereich zu wechseln. In diesen Fenstern oder im Git-Ribbon finden Sie noch weitere nützliche Git-Funktionen.',
    fr: '<span class="appname"></span> permet de voir tous les référentiels Git sur le système, ainsi que les informations sur les états et les branches.<br><br>Ouvrir l’onglet <strong>Git</strong> dans le ruban pour activer ou désactiver le navigateur de référentiels, le navigateur de branches et le volet conflits. Vous découvrirez encore plus de fonctionnalités Git en visualisant ces fenêtres ou en utilisant le ruban Git.',
    es: '<span class="appname"></span> proporciona una visión general de todos los repositorios de Git en el sistema, junto con información sobre el estado y las ramas.<br><br>Abra la ficha <strong>Git</strong> en la cinta de opciones para alternar entre el explorador de repositorios, el explorador de ramas y el panel de conflictos. Descubrirá una funcionalidad de Git aún más útil desde cualquiera de estas ventanas o en la cinta de opciones de Git.',
    it: '<span class="appname"></span>fornisce una panoramica di tutti i repository Git sul tuo sistema oltre a informazioni su branch e stato.<br><br>Apri la scheda <strong>Git</strong> nel ribbon per passare dal browser repository al browser rami (branch) e al pannello conflitti. In queste finestre o nel ribbon Git, scoprirai altre funzioni ancora più utili.',
    ko: '<span class="appname"></span> 시스템의 모든 Git 리포지토리와 상태 및 분기 정보를 제공합니다.<br><br>리본에 있는 <strong>Git</strong> 탭을 열어 리포지토리 브라우저, 분기 브라우저 및 충돌 창을 전환하십시오. 이 창이나 Git 리본에서 더 유용한 Git 기능을 발견 할 수 있습니다.',
    jp: '<span class="appname"></span> では、システム上のすべてのGitリポジトリの概要を、状態とブランチ情報とともに説明します。<br><br>リボンの <strong>Git</strong> タブを開き、リポジトリブラウザ、ブランチブラウザ、および競合ウィンドウを切り替えます。これらのウィンドウやGitリボンには、さらに便利なGit機能があります。',
    ch: '<span class="appname"></span> 提供系统中所有 Git 库的概述、状态和分支信息。<br><br>打开功能区中的 <strong>Git</strong> 选项卡，切换至库浏览器、分支浏览器和“冲突”窗格。在这些窗口或 Git 功能区中，还有更多有用的 Git 功能。',
    cht: '<span class="appname"></span> 提供系統上所有 Git 儲存庫的概述，以及狀態和分支資訊。<br><br>開啟功能區中的<strong>Git</strong>選項卡，以便在儲存庫瀏覽器、分支瀏覽器和衝突窗格之間切換。您可以從這些視窗中的任何一個，或在 Git 功能區中發現更實用的 Git 功能。'
  },

  f_GitConflictsHead: {
    en: 'Resolve Git merge conflicts',
    ptb: 'Resolver conflitos de mesclagem do Git',
    de: 'Git-Mergekonflikte lösen',
    fr: 'Résoudre les conflits de fusion GIT',
    es: 'Resolver conflictos de combinación de Git',
    it: 'Risolvi i conflitti di unione (merge)',
    ko: 'Git 병합 충돌 해결',
    jp: 'Gitマージ競合の解決',
    ch: '解决 Git 合并冲突',
    cht: '解決 Git 合併衝突'
  },

  f_GitConflicts: {
    en: '<span class="appname"></span> prautomatically integrates as mergetool / difftool for command line Git. You can also see repositories and files in conflict states and merge them all from within the <span class="appname"></span> GUI.',
    ptb: '<span class="appname"></span> se integra automaticamente como ferramenta de mesclagem ou comparação para a linha de comando Git. Você também pode ver repositórios e arquivos em estados de conflito e mesclá-los de dentro do <span class="appname"></span> GUI.',
    de: '<span class="appname"></span> wird automatisch als Mergetool/Difftool für die Git-Befehlszeile eingebunden. Sie können auch Repositorys und Dateien in Konfliktzuständen sehen und alle direkt von der <span class="appname"></span>-GUI zusammenführen.',
    fr: '<span class="appname"></span> Intégration automatique comme outil fusion/diff( mergetool / difftool) pour la ligne de commande Git. Vous pouvez voir aussi les référentiels et les fichiers qui sont en état de conflit et les fusionner au niveau de<span class="appname"></span>  la interface graphique.',
    es: '<span class="appname"></span> se integra automáticamente como una herramienta de combinación o de comparación de diferencias para Git en línea de comando. También puede ver los repositorios y archivos en estados de conflicto y combinarlos todos desde la GUI de <span class="appname"></span>.',
    it: '<span class="appname"></span>Integra automaticamente come strumento di unione (merge) / confronto (diff) per riga di comando Git. Puoi anche visualizzare repository e file in stato di conflitto e unirli assieme direttamente dall’interfaccia <span class="appname"></span> GUI.',
    ko: '<span class="appname"></span> 명령 행 Git에 대해 병합툴 / 디프툴로 자동 통합됩니다. 또한 충돌 상태의 리포지토리와 파일을 볼 수 있고 <span class="appname"></span> GUI 내에서 그들을 병합 할 수 있습니다.',
    jp: '<span class="appname"></span> では、コマンドラインGitのマージツール/相違ツールとして自動的に統合されます。また、競合状態のリポジトリとファイルを表示し、それらをすべて<span class="appname"></span> GUI内からマージすることもできます。',
    ch: '<span class="appname"></span> 自动集成为命令行 Git 的合并工具/区分工具。您还可以查看处于冲突状态的库和文件，并在<span class="appname"></span> GUI 中将它们全部合并。 ',
    cht: '<span class="appname"></span> 為命令列 Git 自動整合為合併工具/差異化工具。您還可以查看處於衝突狀態的儲存庫和檔案，並在<span class="appname"></span>GUI 中將它們全部合併。'
  },

  f_GitDiffHead: {
    en: 'Diff versions of a Git file',
    ptb: 'Versões de comparação de um arquivo Git',
    de: 'Versionsunterschiede einer Git-Datei.',
    fr: 'Versions diff d’une fichier Git',
    es: 'Comparación de diferencias de versiones de un archivo Git',
    it: 'Confronta (diff) versioni di un file Git',
    ko: 'Git 파일의 다른 버전',
    jp: 'Gitファイルの相違バージョン',
    ch: 'Git 文件的不同版本',
    cht: 'Git 檔案的差異化版本'
  },

  f_GitDiff: {
    en: 'Ever wanted to compare a file in your repository to a previous or different version of itself? Use Git version diff to compare it to the branch tip, index/staged, working copy, or a version from any other branch or commit!',
    ptb: 'Você já quis comparar um arquivo no seu repositório com uma versão anterior ou diferente dele mesmo? Use o Git versão de comparação para compará-lo com a dica de ramificação, índice/etapa, cópia de trabalho ou uma versão de qualquer outra ramificação ou confirmação!',
    de: 'Wollten Sie schon einmal eine Datei in Ihrem Repository mit einer früheren oder unterschiedlichen Version dieser Datei vergleichen? Verwenden Sie Git-Versionsunterschiede zum Vergleich mit der Zweigspitze, dem Index/bereitgestellt, der Arbeitskopie oder einer Version von einem anderen Zweig oder Commit!',
    fr: 'Vous avez toujours voulu comparer un fichier de votre référentiel à une version précédente ou à une version différente de celui-ci? Utilisez l’outil « Git version diff » pour comparer le fichier à l’extrémité de branche, à l’index/au stage, à la copie de travail ou à une version issue de n’importe quelle branche ou validation.',
    es: '¿Alguna vez ha querido comparar un archivo de su repositorio con una versión anterior o con una versión diferente del mismo archivo? Utilice la comparación de diferencias de Git para compararlo con la sugerencia de rama, índice/temporal, copia de trabajo, o con una versión de cualquier otra rama o confirmación.',
    it: 'Hai mai voluto fare un confronto tra un file nel tuo repository e una sua versione precedente o diversa? Usa il confronto (diff) di versione Git per confrontare alla punta ramo (branch), alla versione nell’area di parcheggio (index/staged), alla copia di lavoro o a un’altra versione in un altro ramo (branch) o commit!',
    ko: '리포지토리에 있는 파일을 이전 또는 다른 버전의 파일과 비교할 생각이 있습니까? Git 버전 디프를 사용하여 브랜치 팁, 인덱스 / 스테이지, 작업 사본 또는 다른 브랜치 또는 커밋의 버전과 비교하십시오!',
    jp: 'リポジトリ内のファイルを以前のバージョンまたは別のバージョンのファイルと比較したいと思ったことはありますか？Gitのバージョン相違を使って、ブランチチップ、インデックス/ステージング済み、作業用コピー、あるいは他のブランチやコミットのバージョンと比較してください。',
    ch: '您是否想要将库中的文件与老版本或不同版本进行比较？使用 Git 版本区分工具，可将文件与分支提示、索引/暂存、工作副本或任何其他分支的版本进行比较或提交！',
    cht: '您是否想過要將儲存庫中的檔案與其自身的先前版本或其他版本進行比較？使用 Git 版本差異化，將其與分支提示、索引/分階段、工作副本或來自其他任何分支或所提交的版本進行比較！'
  },

  f_GitBranchesHead: {
    en: 'Browse Git branches',
    ptb: 'Procurar ramificações Git',
    de: 'Git-Zweige durchsuchen',
    fr: 'Afficher les branches Git',
    es: 'Explorar ramas de Git',
    it: 'Esplora branch Git',
    ko: 'Git 브랜치 브라우즈 ',
    jp: 'Gitブランチのブラウズ',
    ch: '浏览 Git 分支',
    cht: '瀏覽 Git 分支'
  },

  f_GitBranches: {
    en: '<span class="appname"></span> offers Git branch browsing so you can browse files in different branches without having to abandon your current working copy.<br><br>You can resolve or diff conflicts, diff different versions of a file, review working copy changes, blame, and more...all from the branch browser.',
    ptb: '<span class="appname"></span> oferece navegação no Git para que você possa procurar arquivos em diferentes ramificações sem precisar abandonar a sua cópia de trabalho atual.<br><br>Você pode resolver ou comparar conflitos, comparar diferentes versões de um arquivo, revisar as alterações da cópia de trabalho, blame e muito mais... Tudo a partir do navegador de ramificação.',
    de: 'Mit <span class="appname"></span> können Git-Zweige durchsucht werden, sodass Sie nach Dateien in unterschiedlichen Zweigen suchen können, ohne dabei Ihre aktuelle Arbeitskopie verlassen zu müssen.<br><br>Sie können Konflikte lösen oder unterscheiden, verschiedene Versionen einer Datei unterscheiden, Änderungen in der Arbeitskopie ansehen, annotieren und mehr – alles vom Zweig-Browser aus.',
    fr: '<span class="appname"></span> Permet d’afficher les branches Git afin de voir les fichiers présents dans des branches différentes sans avoir besoin d’abandonner votre copie de travail.<br><br>Vous pouvez résoudre les conflits de différenciation, différencier  sur les versions différentes d’un fichier, réviser les changements à une copie de travail, blâmer et plus... en utilisant le navigateur de branches.',
    es: '<span class="appname"></span> ofrece la exploración por las ramas de Git para que se puedan examinar los archivos de diferentes ramas sin tener que abandonar la copia de trabajo actual.<br><br>Puede resolver o comparar las diferencias de conflictos, comparar las diferentes versiones de un fichero, revisar los cambios en la copia de trabajo, responsabilizar y mucho más... todo ello desde el explorador de ramas.',
    it: '<span class="appname"></span>permette di esplorare rami (branch) Git per scorrere file in rami diversi senza dover lasciare la tua copia di lavoro attuale.<br><br>Puoi risolvere o confrontare (diff) conflitti, confrontare (diff) diverse versioni di un file, revisionare modifiche a copie di lavoro, cercare il responsabile e altro... Tutto direttamente dal browser rami (branch).',
    ko: '<span class="appname"></span> Git 브랜치 브라우징을 제공하므로 현재 작업중인 사본을 포기하지 않고도 다른 브랜치에서 파일을 브라우즈할 수 있습니다.<br><br>브랜치 브라우저에서 충돌을 해결하거나 차별화 하고, 파일의 다른 버전을 차별화하고, 작업 사본 변경 사항, 책임 등을 리뷰 할 수 있습니다.',
    jp: '<span class="appname"></span> では、Gitブランチブラウズが提供されているため、現在の作業コピーを破棄することなく、異なるブランチのファイルをブラウズできます。<br><br>競合の解決や相違、異なるバージョンのファイルの相違、作業中のコピーの変更の確認、追及などを行うことができます。すべてをブランチブラウザから実行します。',
    ch: '<span class="appname"></span>提供 Git 分支浏览功能，因此，您可以浏览不同分支中的文件，而不必放弃当前的工作副本。<br><br>解决或区分冲突、区分文件的不同版本、查看工作副本更改和责任等等操作，在分支浏览器中统统都能搞定。',
    cht: '<span class="appname"></span> 提供 Git 分支瀏覽功能，以便您無須放棄目前的工作副本即可瀏覽不同分支中的檔案。<br><br>您可透過分支瀏覽器來解決或差異化衝突、差異化檔案的不同版本、檢閱工作副本的變更、責任等更多功能。'
  },




};